#include "qdeclarativedbusinterface.h"
#include <QDeclarativeItem>
#include <QDBusInterface>
#include <QDebug>

QDeclarativeDBusInterface::QDeclarativeDBusInterface(QDeclarativeItem *parent) :
    QObject(parent),
    m_iface(0)
{
}

QString QDeclarativeDBusInterface::service() const {
    return m_service;
}

void QDeclarativeDBusInterface::setService(const QString &service) {
    if (service != this->service()) {
        m_service = service;

        if ((!this->service().isEmpty()) && (!this->path().isEmpty()) && (!this->interface().isEmpty())) {
            if (m_iface) {
                delete m_iface;
            }

            qDebug() << "Initializing DBus interface";

            m_iface = new QDBusInterface(this->service(), this->path(), this->interface(), QDBusConnection::sessionBus(), this);
        }
    }
}

QString QDeclarativeDBusInterface::path() const {
    return m_path;
}

void QDeclarativeDBusInterface::setPath(const QString &path) {
    if (path != this->path()) {
        m_path = path;

        if ((!this->service().isEmpty()) && (!this->path().isEmpty()) && (!this->interface().isEmpty())) {
            if (m_iface) {
                delete m_iface;
            }

            qDebug() << "Initializing DBus interface";

            m_iface = new QDBusInterface(this->service(), this->path(), this->interface(), QDBusConnection::sessionBus(), this);
        }
    }
}

QString QDeclarativeDBusInterface::interface() const {
    return m_interface;
}

void QDeclarativeDBusInterface::setInterface(const QString &interface) {
    if (interface != this->interface()) {
        m_interface = interface;

        if ((!this->service().isEmpty()) && (!this->path().isEmpty()) && (!this->interface().isEmpty())) {
            if (m_iface) {
                delete m_iface;
            }

            qDebug() << "Initializing DBus interface";

            m_iface = new QDBusInterface(this->service(), this->path(), this->interface(), QDBusConnection::sessionBus(), this);
        }
    }
}

void QDeclarativeDBusInterface::call(const QString &method, const QVariantList &args) {
    if ((!this->service().isEmpty()) && (!this->path().isEmpty()) && (!this->interface().isEmpty())) {
        if (!m_iface) {
            qDebug() << "Initializing DBus interface";
            m_iface = new QDBusInterface(this->service(), this->path(), this->interface(), QDBusConnection::sessionBus(), this);
        }

        if (!args.isEmpty()) {
            m_iface->callWithArgumentList(QDBus::NoBlock, method, args);
        }
        else {
            m_iface->call(QDBus::NoBlock, method);
        }
    }
}
