import QtQuick 1.0

Dialog {
    id: root

    property alias icon: icon.source
    property alias message: label.text
    property string acceptButtonText
    property string rejectButtonText

    height: screen.inPortrait ? (buttons.length * 70) + 180 : (buttons.length * 70) + 100
    modal: true
    content: Item {
        anchors.fill: parent

        Flickable {
            id: flicker

            anchors.fill: parent
            contentHeight: row.height
            contentWidth: width

            Row {
                id: row

                anchors {
                    left: parent.left
                    right:parent.right
                    top: parent.top
                }
                spacing: platformStyle.paddingSmall

                Image {
                    id: icon
                }

                Label {
                    id: label

                    width: parent.width - icon.width - platformStyle.paddingSmall
                    wrapMode: Text.WordWrap
                }
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }

    buttons: [
        Loader {
            id: acceptButtonLoader

            sourceComponent: acceptButtonText == "" ? undefined : acceptButton
        },

        Loader {
            id: rejectButtonLoader

            sourceComponent: rejectButtonText == "" ? undefined : rejectButton
        }
    ]

    Component {
        id: acceptButton

        DialogButton {
            text: acceptButtonText
            onClicked: root.accept()
        }
    }

    Component {
        id: rejectButton

        DialogButton {
            text: rejectButtonText
            onClicked: root.reject()
        }
    }
}
