import QtQuick 1.0
import "CreateObject.js" as ObjectCreator

Row {
    id: root

    property Item checkedAction

    signal triggered(variant action)

    objectName: "__actionGroup"
    anchors.horizontalCenter: !parent ? undefined : parent.horizontalCenter
    width: !parent ? 0 : Math.min(parent.width, children.length * 150)
    onCheckedActionChanged: triggered(checkedAction)

    QtObject {
        id: internal

        function setUpAction(action, index, len) {
            var style = ObjectCreator.createObject(Qt.resolvedUrl("ButtonRowStyle.qml"), action);
            style.buttonIndex = index;
            style.buttonRowLength = len;
            action.platformStyle = style;
            action.triggered.connect(setCheckedAction);

            if ((action.checked) || (checkedAction === action)) {
                setCheckedAction(action);
            }
        }

        function setCheckedAction(action) {
            action.checked = true;
            checkedAction = action;

            for (var i = 0; i < children.length; i++) {
                if (children[i] !== checkedAction) {
                    children[i].checked = false;
                }
            }
        }
    }

    Component.onCompleted: {
        for (var i = 1; i <= children.length; i++) {
            internal.setUpAction(children[i - 1], i, children.length);
        }
    }

    Component.onDestruction: {
        for (var i = 0; i < children.length; i++) {
            children[i].triggered.disconnect(internal.setCheckedAction);
        }
    }
}
