/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Components project.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

import Qt 4.7
import "." 1.0

AbstractMenu {
  id: root
/*
    platformTitle: BorderImage {
        id: topDivider
        anchors.left: parent.left
        anchors.right: parent.right
        height: 2
        source: "" // "image://theme/meegotouch-button-objectmenu-background-vertical-top"
        border { top: 2; bottom: 1; left: 1; right: 1 }
    }
*/

    __statesWrapper.transitions: [
        Transition {
            from: "visible"; to: "hidden"
            SequentialAnimation {
                ScriptAction {script: {
                        __fader().state = "hidden";
                        root.status = DialogStatus.Closing;
                    }
                }

                NumberAnimation {target: __menuPane;
                                 property: screen.currentOrientation == Screen.Portrait ? "anchors.bottomMargin" : "anchors.rightMargin";
                                 easing.type: Easing.InOutQuint;
                                 to: screen.currentOrientation == Screen.Portrait ? -__menuPane.height : -__menuPane.width;
                                 from: 0; duration: 350}

                NumberAnimation {target: __menuPane; property: "opacity";
                                 from: 1.0; to: 0.0; duration: 0}

                ScriptAction {script: {
                        status = DialogStatus.Closed;
                    }
                }
            }
        },
        Transition {
            from: "hidden"; to: "visible"
            SequentialAnimation {
                ScriptAction {script: {
                        __fader().state = "visible";
                        root.status = DialogStatus.Opening;
                        __menuPane.anchors.rightMargin = 0;
                        __menuPane.anchors.bottomMargin = 0;
                    }
                }

                NumberAnimation {target: __menuPane;
                                 property: screen.currentOrientation == Screen.Portrait ? "anchors.bottomMargin" : "anchors.rightMargin";
                                 easing.type: Easing.InOutQuint;
                                 from: screen.currentOrientation == Screen.Portrait ? -__menuPane.height : -__menuPane.width;
                                 to: 0; duration: 350}

                ScriptAction {script: {
                        status = DialogStatus.Open;
                    }
                }
            }
        }
    ]
}
