/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Components project.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

import Qt 4.7
import org.maemo.fremantle 1.0
import org.maemo.extras 1.0

Page {
    id: container
    anchors.margins: UiConstants.DefaultMargin
    tools: commonTools

    Column {
        id: controls
        x: 350

        Button {
            id: addButton
            text: "Increase rating"
            onClicked: { indicator.ratingValue++ }
        }
        Button {
            id: removeButton
            text: "Decrease rating"
            onClicked: { indicator.ratingValue-- }
        }
        Button {
            id: addCount
            text: "Increase votes counted"
            onClicked: { indicator.count++ }
        }
        Button {
            id: removeCount
            text: "Decrease votes counted"
            onClicked: { indicator.count-- }
        }
        Button {
            id: negativeButton
            text: "Inverted visual"
            onClicked: { theme.inverted = true }
        }

        Button {
            id: positiveButton
            text: "Normal visual"
            onClicked: { theme.inverted = false }
        }
    }

    Column {
        id: indicators
        x: 25
        y: 100
        spacing: 10

        Text {
            id: t1
            text: "Rating indicator with vote count"
            font.pointSize: 14
        }

        Item {
            id: r1
            width: 200
            height:  50

            RatingIndicator {
                id: indicator
                objectName: "indicator1Object"
                ratingValue: 3
                maximumValue: 5
                count: 3
            }
        }

        Text {
            id: t2
            text: "Rating indicator without vote count"
            font.pointSize: 14
        }

        Item {
            id: r2
            width: 200
            height: 50

            RatingIndicator {
                id: i2
                maximumValue: 5
                ratingValue: 3
            }
        }
    }
}
