//Banner.h: Header file for Banner class (implementation of custom Maemo5/Hildon style information banner)
#ifndef BANNER_H
#define BANNER_H

#include <QObject>
#include <QWidget>
#include <QDialog>
#include <QLabel>
#include <QHBoxLayout>
#include <QApplication>
#include <QDesktopWidget>
#include <QTimer>

#define DEFAULT_TIMEOUT_MS 3000 //default notification timeout (in msecs)


class Banner : public QDialog
{
    Q_OBJECT

public:

    Banner(QWidget *parent = 0);
    ~Banner();

    static void information(QWidget* parent, const QString& msg, qint32 timeout = DEFAULT_TIMEOUT_MS); //show general information banner

private:

    QHBoxLayout m_Layout; //banner layout manager
    QLabel* m_pLabel; //pointer to current label instance

    void addLabelWidget(QLabel *label); //add label widget to internal layout
    void activateTimeout(qint32 timeout); //activate notification timeout

private slots:

    void OnTimeout(); //triggered when notification timeout has elapsed (hide notification)


};


#endif // BANNER_H
