//AboutDialog.h: Header file for the custom About dialog class (class derives from QDialog).
#ifndef ABOUTDIALOG_H
#define ABOUTDIALOG_H

#include <QObject>
#include <QDialog>
#include <QGridLayout>
#include <QLabel>
#include <QPushButton>
#include <QTextBrowser>
#include <QPixmap>

class AboutDialog : public QDialog
{
    Q_OBJECT

    public:

        AboutDialog(QWidget* pParent = 0); //default constructor
        ~AboutDialog(); //default destructor

        void setText(const QString& text); //set about dialog text content

        void setTopIcon(const QString& iconPath); //set about dialog top icon

        void setBottomIcon(const QString& iconPath); //set about dialog bottom icon

    private:

        QGridLayout m_MainLayout; //main dialog layout manager

        QLabel m_TextContent; //dialog textual content

        QLabel m_Icon; //dialog icon

        QLabel m_BottomIcon; //additional icon (used to display Spotify Core logo)

        QPushButton m_DoneBtn; //Done button

    private slots:

        void OnDoneBtn(); //done button clicked handler

};

#endif // ABOUTDIALOG_H
