#ifndef SpectrumAnalyzer_H
#define SpectrumAnalyzer_H

#include <QWidget>
#include <QMouseEvent>

class SpectrumAnalyzer : public QWidget
{
	Q_OBJECT

public:
	SpectrumAnalyzer(QWidget *parent, int width, int height);
	~SpectrumAnalyzer();

	void setColor(QColor color);
        void Start();
        void Stop();

protected:
	void paintEvent(QPaintEvent *event);
	void mousePressEvent(QMouseEvent *event);

private:

        QTimer* m_pTimer;
	QColor m_color;
	int m_width;
	int m_height;
	int m_p1;
	int m_p2;
	int m_p3;
	int m_p4;
	bool m_playing;

private slots:
	void updateAnalyzers();

signals:
	void clicked();
};

#endif // SpectrumAnalyzer_H
