#include "albumbrowser.h"
#include <QDebug>
#include "artist.h"
#include "album.h"

namespace Spotify
{

    AlbumBrowser::AlbumBrowser(sp_session* session, sp_albumbrowse* ab, QObject* parent ):
            Spotify::TrackCollection( parent ),
            m_session( session ),
            m_albumBrowser( ab ),
            m_album( 0 ),
            m_artist( 0 )
    {
        // Implicitly reffed by sp_albumbrowse_create()
    }

    bool AlbumBrowser::load()
    {
        if( !m_albumBrowser ) return false;

        if( m_albumBrowser && sp_albumbrowse_is_loaded( m_albumBrowser ) && !m_isLoaded )
        {
            // Set album:
            if( !m_album )
            {
                m_album = new Spotify::Album( sp_albumbrowse_album( m_albumBrowser ), false, this );
                if( !m_album->isLoaded() && !m_album->load() )
                {
                    qDebug() << "Unable to load album..";
                    return false;
                }
            }

            // Set artist:
            if( !m_artist )
            {
                m_artist = new Spotify::Artist( sp_albumbrowse_artist( m_albumBrowser ), false, this );
                if( !m_artist->isLoaded() && !m_artist->load() )
                {
                    qDebug() << "Unable to load artist..";
                    return false;
                }
            }

            // Set copyrights:
            if( m_copyrights.isEmpty() )
            {
                int numCopyrights = sp_albumbrowse_num_copyrights( m_albumBrowser );
                for( int i = 0; i < numCopyrights; ++i )
                {
                    const char* charData;
                    charData = sp_albumbrowse_copyright( m_albumBrowser, i );
                    QString copyright = QString::fromUtf8( charData, strlen( charData ) );
                    m_copyrights.append( copyright );
                }
            }

            // Set review
            if(m_review.isEmpty())
            {
                const char* charData;
                charData = sp_albumbrowse_review(m_albumBrowser);
                m_review = QString::fromUtf8(charData, strlen(charData));
            }

            // Set tracks:
            if( m_tracks.isEmpty() )
            {
                int numTracks = sp_albumbrowse_num_tracks( m_albumBrowser );
                for( int i = 0; i < numTracks; ++i )
                {
                    sp_track* sptrack = sp_albumbrowse_track( m_albumBrowser, i );
                    Spotify::Track* track = new Spotify::Track(m_session, sptrack, false, this );
                    addTrack( track );

                    // Tracks should be loaded:
                    if( !track->isLoaded() && !track->load() )
                        return false;
                }
            }
            m_isLoaded = true;
            emit loaded();
        }

        return m_isLoaded;
    }

    void AlbumBrowser::sortByDiscIndex()
    {
        //sort album tracks by disc (album) position index (ascending order)
        qSort(m_tracks.begin(),m_tracks.end(),tracksByDiscIndexAsc);
    }

    AlbumBrowser::~AlbumBrowser()
    {

    }

} // namespace Spotify
