#ifndef TRACK_H
#define TRACK_H
#include <libspotify/api.h>
#include <QString>
#include <QObject>
#include <QTime>

namespace Spotify
{
    class Link;
    class Album;
    class Artist;
    class Session;
    class Track: public QObject
    {
        Q_OBJECT

        public:
            Track( sp_session* session, sp_track* track = 0, bool ref = false, QObject* parent = 0 );
            Track( sp_session* session, Spotify::Track&, bool ref = true );
            ~Track();


            sp_track* getTrack() const { return m_track; }
            bool isLoaded() const { return m_loaded; }
            bool isAvailable() const { return m_available; }
            Spotify::Artist* getArtist() { return m_artist; }
            Spotify::Album* getAlbum() { return m_album; }
            QString getName() { return m_name; }
            QTime getDuration() const { return m_duration; }
            QString getDurationAsString();
            int getPopularity() const { return m_popularity; }
            int getDisc() const { return m_disc; }
            int getIndex() const { return m_index; }

            bool load();
            static Spotify::Track* fromLink(sp_session* session, Spotify::Link& link, QObject* parent = 0 );

        signals:
            void loaded();

        private:
            sp_session* m_session;
            sp_track* m_track;
            bool m_loaded;
            bool m_available;
            Spotify::Artist* m_artist;
            Spotify::Album* m_album;
            QString m_name;
            QTime m_duration;
            int m_popularity;
            int m_disc;
            int m_index;
            bool m_hasRef;

            /*int m_intduration;
            QString m_artist;
            QString m_title;
            QString m_album;
            QString m_uri;

            const byte* m_coverArtID;*/
    };
} // namespace Spotify


//compare non-members (for sorting)
bool trackLessThanCaseInsensitive(Spotify::Track*, Spotify::Track*);
bool tracksByNameAsc(Spotify::Track*, Spotify::Track*);
bool tracksByArtistNameAsc(Spotify::Track*, Spotify::Track*);
bool tracksByAlbumNameAsc(Spotify::Track*, Spotify::Track*);
bool tracksByNameDesc(Spotify::Track*, Spotify::Track*);
bool tracksByArtistNameDesc(Spotify::Track*, Spotify::Track*);
bool tracksByAlbumNameDesc(Spotify::Track*, Spotify::Track*);
bool tracksByPopularityDesc(Spotify::Track*, Spotify::Track*);
bool tracksByDiscIndexAsc(Spotify::Track*, Spotify::Track*);


#endif // TRACK_H
