#include "playlist.h"
#include "link.h"
#include "user.h"
#include <QDebug>

namespace Spotify
{
    Playlist::Playlist(sp_session* session, sp_playlist* playlist, QObject* parent ):
            TrackCollection( parent ),
            m_session( session ),
            m_playlist( playlist ),
            m_owner( 0 ),
            m_position( 0 )
    {
        m_isLoaded = false;
        load();
    }

    bool Playlist::load()
    {
        if( m_playlist )
        {
            if( m_name.isEmpty() )
            {
                const char* charData = sp_playlist_name( m_playlist );
                m_name = QString::fromUtf8( charData, strlen( charData ) );
            }
            m_numTracks = sp_playlist_num_tracks( m_playlist );

            if( !m_owner )
                m_owner = new Spotify::User( sp_playlist_owner( m_playlist ) );
            /*if( m_owner && !m_owner->isLoaded() && !m_owner->load() )
            {
                qDebug() << "Tried to load playlist owner; failed.";
                return false;
            }
            */

            m_collaborative = sp_playlist_is_collaborative( m_playlist );

            // First time we get tracks for this playlist
            if( m_tracks.count() == 0 )
            {
                for( int i = 0; i < m_numTracks; ++i )
                {
                    sp_track* track = sp_playlist_track( m_playlist, i );
                    Spotify::Track* strack = new Spotify::Track(m_session, track, false, this );
                    m_tracks.append( strack );
                    m_tracksOriginal.append( strack );
                }
            }

            m_isLoaded = sp_playlist_is_loaded(m_playlist);
            if(m_isLoaded)
                emit loaded();

            return m_isLoaded;
        }
    }

    void Playlist::updateName()
    {
        //m_isLoaded = sp_playlist_is_loaded( m_playlist );
        if( m_playlist )
        {
            const char* charData = sp_playlist_name( m_playlist );
            m_name = QString::fromUtf8( charData, strlen( charData ) );
            qDebug() << "New name is " << m_name;
            emit renamed();
        }
    }

    void Playlist::updateState()
    {
        if( m_playlist && sp_playlist_is_loaded( m_playlist ) )
        {
            m_collaborative = sp_playlist_is_collaborative( m_playlist );
            emit stateChanged();
        }
    }

    void Playlist::setPosition(int pos)
    {
        m_position = pos;
    }

    int Playlist::getPosition()
    {
        return m_position;
    }

    int Playlist::getNumTracks()
    {
        if(m_playlist && sp_playlist_is_loaded(m_playlist))
        {
            return sp_playlist_num_tracks( m_playlist );
        }
        else
        {
            return 0;
        }
    }

    Playlist::~Playlist()
    {
        if( m_owner )
            m_owner->deleteLater();
    }

} // namespace Spotify
