//DBusWrapper.h: Header for the D-bus wrapper class (e.g., for handling display backlight state)

#ifndef DBUSWRAPPER_H
#define DBUSWRAPPER_H

#include <QObject>
#include <QTimer>
#include <QDebug>
#include <QDBusConnection>
#include <QDBusInterface>
#include <QDBusMessage>
#include <QDBusArgument>
#ifdef Q_WS_MAEMO_5
    #include <mce/dbus-names.h>
    #include <mce/mode-names.h>
#endif

//defines for zoom keypress up / down
#define MM_KEY_UP  73
#define MM_KEY_DOWN 74

#define KEYPAD_UNBLOCK_INTERVAL 60000 //interval after which new keypad unblock d-bus request should be sent (in msecs)

#define DBUS_HAL_SERVICE           "org.freedesktop.Hal"
#define DBUS_HAL_DEVICE_INTERFACE  "org.freedesktop.Hal.Device"
#define DBUS_HAL_MANAGER_INTERFACE "org.freedesktop.Hal.Manager"
#define DBUS_HAL_MANAGER_PATH       "/org/freedesktop/Hal/Manager"
#define DBUS_HAL_HEADPHONE_PATH     "/org/freedesktop/Hal/devices/platform_headphone"

struct HalPropModifiedStruct
{
    QString value;
    bool state1;
    bool state2;
};
Q_DECLARE_METATYPE(HalPropModifiedStruct)

class DBusWrapper : public QObject
{
    Q_OBJECT

public:

    DBusWrapper(QObject *parent = 0); //constructor
    ~DBusWrapper(); //destructor

#ifdef Q_WS_MAEMO_5
    void enableHWZoomKeys(); //enable / grab control of HW keypad (zoom keys)
    void disableHWZoomKeys(); //disable / release HW keypad (zoom keys)

    void setVolume(quint32 volume); //set current system volume level via Mafw D-Bus interface
    quint32 getVolume(); //get the current system volume level via Mafw D-Bus interface

private:

    QDBusMessage m_unblock_keypad_msg;

    QTimer *m_pKeypadUnblockTimer; //timer instance used for sending keypad unblock messages (60 secs intervals)



private slots:

    void setDisplayState(const QString &state);
    void displayStateChanged(const QDBusMessage &message);
    void displayStateError(const QDBusError &error);
    void unblockKeypad();
    void zoomKeyPressed(quint32 keycode, quint32 unused);
    void OnHalCondition(QString condition, QString value);
    void OnHalDeviceRemoved(QString device);
    void OnHalHeadphonePropModified();

signals:

    void onDisplayStateChange(bool); //display state change signal (true=ON, false=OFF).
    void onZoomKeyPressed(quint32); //notification upon HW zoom keypress. Parameter contains the keycode (state up/down) for the pressed key
    void onHalButtonPressed(const QString&); //button pressed notification from Hal (device). String parameter identifies button pressed.
    void onHeadsetRemoved(); //headset removed notification from Hal device manager.

#endif

};

#endif // DBUSWRAPPER_H
