#ifndef LOGINDIALOG_H
#define LOGINDIALOG_H

#include <QtGui/QDialog>
#include <QDesktopWidget>
#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QMessageBox>
#include <QtGui/QCheckBox>
#include <QtGui/QComboBox>
#include <QDebug>
#include <QSettings>
#include "global_defs.h"


class LoginDialog : public QDialog
{
    Q_OBJECT

public:
    LoginDialog(QSettings* pSettings, QWidget *parent = 0);
    ~LoginDialog();

    void resetState();

private:

    QGridLayout m_Layout;

    QLabel m_UserIDText;
    QLineEdit m_UserIDInput;
    QLabel m_PasswordText;
    QLineEdit m_PasswordInput;

    QPushButton m_LoginBtn;

    QSettings* m_pAppSettings; //pointer to app settings instance

private slots:

    void OnLogin();
    void OnOrientationChanged(); //device orientation changed (e.g, screen rotate)

signals:

    void doSpotifyLogin(const QString&, const QString&); //request to login

};

#endif // LOGINDIALOG_H
