//SettingsDialog.h: Header file for the SettingsDialog class (dialog for management of client-related settings).

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QApplication>
#include <QDesktopWidget>
#include <QDialog>
#include <QDebug>
#include <QSettings>
#include <QGroupBox>
#include <QLabel>
#include <QLineEdit>
#include <QCheckBox>
#include <QScrollArea>
#include <QPushButton>
#include <QGridLayout>
#include <QStringList>
#include <QStringListModel>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5ListPickSelector>
    #include <QMaemo5ValueButton>
    #include <QMaemo5InformationBox>
#else
    #include <QComboBox>
    #include "Banner.h"
#endif

#include "global_defs.h"


//defines for default setting values

#define MAX_TRACKS_DEFAULT  500
#define MAX_ALBUMS_DEFAULT 10
#define MAX_ARTISTS_DEFAULT 10
#define MIN_BUFFER_LEN_DEFAULT  30
#define PRE_BUFFERING_DEFAULT    1
#define SAVE_CREDENTIALS_DEFAULT 0
#define HIDE_COVERART_DEFAULT 0
#define ENABLE_SCROBBLING_DEFAULT 0
#define ORIENTATION_DEFAULT 0
#define PLAYLIST_LOADING_TO_DEFAULT 30
#define PAUSE_ON_HEADSET_UNPLUG_DEFAULT 0
#define LANG_DEFAULT "en"
#define SPOTIFY_RECONNECT_INTERVAL 60


class SettingsDialog : public QDialog
{
    Q_OBJECT

public:

    SettingsDialog(QSettings* pSettings, QWidget* pParent = 0); //default contructor

    ~SettingsDialog(); //destructor

     void readSettings(); //read and set current settings

private:

    QSettings* m_pAppSettings; //app settings instance

    QGridLayout m_MainLayout; //dialog main layout

    QScrollArea m_MainArea; //main scrollarea

    QWidget m_MainAreaLayout; //layout containing main scrollarea

    QGridLayout m_GridLayout; //elements contained within the main scrollarea

    QGroupBox m_SearchOptions; //container for search related settings

    QGridLayout m_SearchOptionLayout;

    QGroupBox m_BufferingOptions; //container for settings related to buffering

    QGridLayout m_BufferingOptionLayout;

    QGroupBox m_LoginOptions; //container for login-related settings

    QGridLayout m_LoginOptionLayout;

    QCheckBox m_SaveCredentials; //checkbox to indicate whether the user login credentails should be stored (i.e., for auto-login)

    QCheckBox m_HideCoverArt; //checkbox to indicate whether the coverart should be hidden in the Queue View (to free more space for track info).

    QStringList m_bitrateList; //list of available bitrate alternatives

#ifdef Q_WS_MAEMO_5

    QMaemo5ValueButton m_PreferredBitrateBtn; //value type button for selecting the preferred bitrate

    QMaemo5ListPickSelector *m_pPreferredBitrateSelector; //pick selector associated with preferred bitrate value button

#else

    QComboBox m_PreferredBitrateCombo; //combo for selecting current bitrate

#endif

    QGroupBox m_PlaylistOptions; //container for playlist related settings

    QGridLayout m_PlaylistOptionLayout;

    QGroupBox m_ScrobblingOptions; //container for settings related to Last.fm scrobbling

    QGridLayout m_ScrobblingOptionLayout;

    QLabel m_maxSearchTracksCaption;
    QLineEdit m_maxSearchTracksInput; //max. tracks returned by search

    QLabel m_maxSearchAlbumsCaption;
    QLineEdit m_maxSearchAlbumsInput; //max. albums returned by search

    QLabel m_maxSearchArtistsCaption;
    QLineEdit m_maxSearchArtistsInput; //max. artists returned by search

    QLabel m_MinBufferLenCaption;
    QLineEdit m_MinBufferLenInput;  //min. buffer length used (in secs)

#ifdef Q_WS_MAEMO_5

    QMaemo5ValueButton m_UILangBtn; //value type button for selecting current UI language

    QMaemo5ListPickSelector *m_pUILangSelector; //pick selector associated with UI language button

#else

    QComboBox m_UILangCombo; //combo for selecting current UI language

#endif

    QStringList m_UILangList; //list of possible UI language values (e.g., English)

    QStringList m_UILangCodeList; //internal list of corresponding UI language codes (e.g., en for English)

    QCheckBox m_PreBufferNextTrackSelection; //selected if automatic buffering of next track should be activated

    QStringList m_orientationList; //list of device orientation values

#ifdef Q_WS_MAEMO_5

    QMaemo5ListPickSelector *m_pOrientationSelector; //pick selector associated with the orientation value button

    QMaemo5ValueButton m_OrientationBtn; //value type button for selecting desired screen orientation

#else

    QComboBox m_OrientationCombo; //combo box for selecting desired screen orientation

#endif

    QLabel m_PlaylistLoadingTOCaption;
    QLineEdit m_PlaylistLoadingTOInput; //timeout value for playlist loading (in secs)

    QCheckBox m_PauseOnHSDisconnSelection; //selection to enable automatic pausing of music playback in case headset is unplugged

    QCheckBox m_EnableScrobblingSelection; //enable / disable scrobbling to Last.Fm

    QLabel m_LastFMUserIDCaption;
    QLineEdit m_LastFMUserIDInput;  //Last.fm User ID input

    QLabel m_LastFMPasswordCaption;
    QLineEdit m_LastFMPasswordInput;  //Last.fm password input

    QPushButton m_SaveSettingsBtn; //Save current settings button

    //members holding current settings

    qint32 m_maxSearchTracks;

    qint32 m_maxSearchAlbums;

    qint32 m_maxSearchArtists;

    qint32 m_minBufferLen;

    qint32 m_preBufferingActive;

    qint32 m_saveCredentials;

    qint32 m_hideCoverart;

    QString m_strUserID;

    QString m_strUserPwd;

    qint32 m_prefBitrate;

    qint32 m_currOrientation;

    qint32 m_playlistLoadingTO;

    qint32 m_pauseOnHsetUnplugged;

    qint32 m_enableScrobbling;

    qint32 m_currUILang;

    QString m_strLastFMUserID;

    QString m_strLastFMPassword;

    void saveSettings(); //save (modified) settings

    void setCapsLandscape();
    void setCapsPortrait();

private slots:

    void OnSaveSettingsBtn();
    void OnScrobblingStateChanged(int newState);
    void OnOrientationChanged(); //device orientation changed (e.g, screen rotate)

signals:

    void settingsSaved(); //signal emitted when some setting has been changed

};

#endif // SETTINGSDIALOG_H
