//ConnectionManager.cpp: Implementation of the ConnectionManager class.

#include "ConnectionManager.h"

ConnectionManager::ConnectionManager(QObject *pParent)
    : QObject(pParent)
{
    //constructor; initialise current network configuration / session etc.

   //set up signal / slot connections
   connect(&m_netConfMan,SIGNAL(onlineStateChanged(bool)),SLOT(OnOnlineStateChanged(bool)));

   m_currNetworkStatus=QSystemNetworkInfo::UndefinedStatus;

   m_pNetInfo = new QSystemNetworkInfo(this);
   connect(m_pNetInfo,SIGNAL(networkStatusChanged(QSystemNetworkInfo::NetworkMode,QSystemNetworkInfo::NetworkStatus)),SLOT(OnNetworkStatusChanged(QSystemNetworkInfo::NetworkMode,QSystemNetworkInfo::NetworkStatus)));

   QList<QNetworkConfiguration> configs = m_netConfMan.allConfigurations(QNetworkConfiguration::Active); //get list of active network configs
   qDebug() << "Num of active configs "  << configs.size();
   if(configs.size()>0)
   {
       m_activeNetConf = configs.at(0);
       m_pNetSess = new QNetworkSession(m_activeNetConf,this);
       qDebug() << "Set active bearer: " << m_activeNetConf.bearerTypeName();
       connect(m_pNetSess,SIGNAL(stateChanged(QNetworkSession::State)),SLOT(OnSessionStateChanged(QNetworkSession::State)));
       connect(m_pNetSess,SIGNAL(newConfigurationActivated()),SLOT(OnNewConfigActivated()));
   }
}

ConnectionManager::~ConnectionManager()
{
}

void ConnectionManager::OnNetworkStatusChanged(QSystemNetworkInfo::NetworkMode mode, QSystemNetworkInfo::NetworkStatus newStatus)
{
    qDebug() << "Mode: " << mode << ", status: " << newStatus;
    if(newStatus==QSystemNetworkInfo::Connected && m_currNetworkStatus!=QSystemNetworkInfo::UndefinedStatus) //new network status is Connected; send reconnect req.
        emit reconnectRequired();
    m_currNetworkStatus=newStatus;
}

bool ConnectionManager::currOnlineState()
{
    //Return true if current state is online; otherwise returns false (offline)
    return m_netConfMan.isOnline();
}

void ConnectionManager::OnOnlineStateChanged(bool isOnline)
{
    //notification that current active network config's online state has changed.
    qDebug() << "IsOnline: " << isOnline;
    if(isOnline)
     emit reconnectRequired();
}

void ConnectionManager::OnNewConfigActivated()
{
    //new network config activated for current session
    qDebug() << "New config activated";
}

void ConnectionManager::OnSessionStateChanged(QNetworkSession::State newState)
{
//notification about session state change
    qDebug() << "Session state change: " << newState;
    if(newState==QNetworkSession::Connected||newState==QNetworkSession::Disconnected)
        emit reconnectRequired();
}


