#include "logindialog.h"

LoginDialog::LoginDialog(Spotify::Session* pSession, QSettings* pSettings, QWidget *parent)
    : QDialog(parent)
{

 //construct login dialog UI

    m_pSession = pSession;

    m_pAppSettings = pSettings;

    m_bSessionInit = false;

    //setup signal / slot connections

    connect(&m_LoginBtn,SIGNAL(clicked()),SLOT(OnLogin()));
   //connect(QApplication::desktop(), SIGNAL(resized(int)),SLOT(OnOrientationChanged()));

    setWindowTitle(tr("QSpot - Login"));

    //set up UI elements
    m_UserIDText.setText(tr("UserID:"));
    m_UserIDInput.setInputMethodHints(Qt::ImhNoAutoUppercase); //no auto-uppercase mode
    m_PasswordText.setText(tr("Password:"));
    m_PasswordInput.setEchoMode(QLineEdit::Password);

    m_LoginBtn.setText(tr("Login"));

    if(m_pAppSettings)
    {
        //read save credentials state from the app settings file
        int saveCredentials = m_pAppSettings->value("QSpot/SaveCredentials",0).toInt();
        if(saveCredentials)
        { //restore saved credentials (UserID and password) from settings file
            m_UserIDInput.setText(m_pAppSettings->value("QSpot/UserID","").toString());
            m_PasswordInput.setText(m_pAppSettings->value("QSpot/Password","").toString());
        }
        //read preferred bitrate from settings file
        int prefBitrate = m_pAppSettings->value("QSpot/PrefBitrate",IDX_BITRATE_160k).toInt();
        if(prefBitrate==IDX_BITRATE_96k)
            m_selectedBitrate = SP_BITRATE_96k;
        else if(prefBitrate==IDX_BITRATE_320k)
            m_selectedBitrate = SP_BITRATE_320k;
        else //default bitrate
            m_selectedBitrate = SP_BITRATE_160k;
    }

    m_Layout.addWidget(&m_UserIDText,0,0);
    m_Layout.addWidget(&m_UserIDInput,0,1);
    m_Layout.addWidget(&m_PasswordText,1,0);
    m_Layout.addWidget(&m_PasswordInput,1,1);
    m_Layout.addWidget(&m_LoginBtn,2,1);
    m_Layout.setRowStretch(1,1);
    m_Layout.setRowStretch(2,50);

    setLayout(&m_Layout);
}

LoginDialog::~LoginDialog()
{
}


void LoginDialog::OnLogin()
{
    QMessageBox msgBox;

    //request to login to Spotify
    if(!m_bSessionInit)
    {
        m_pSession->init(m_selectedBitrate); //init the spotify session (if not already done)
        m_bSessionInit = true;
    }
    Spotify::Error err = m_pSession->login(m_UserIDInput.text(),m_PasswordInput.text());
    if(err.isError())
    {
        msgBox.setText("Error:" + err.toString());
        msgBox.exec();
    }
    else
    {
        m_LoginBtn.setDisabled(true);
        setAttribute(Qt::WA_Maemo5ShowProgressIndicator,true); //display progress indicator
    }
}


void LoginDialog::resetState()
{
	//reset state after e.g., unsuccessful login
	setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false); //hide progress indicator
	m_LoginBtn.setDisabled(false);
        //m_UserIDInput.setText("");
	m_UserIDInput.setCursorPosition(0);
        //m_PasswordInput.setText("");
	m_PasswordInput.setCursorPosition(0);
	m_UserIDInput.setFocus();
        m_bSessionInit = true; //make sure we do not re-initialise the session
}

void LoginDialog::OnOrientationChanged()
{
    //device orientation changed (e.g, screen rotate)

  /*  QRect screenGeometry = QApplication::desktop()->screenGeometry(); // get current screen geometry
    if (screenGeometry.width() > screenGeometry.height())
    {
        //switch to landscape mode
    }
    else
    {
        //switch to portrait mode
    }

    */
}

