#include "error.h"


Spotify::Error::Error():
        m_error( SP_ERROR_OK )
{
}

Spotify::Error::Error( sp_error error ):
        m_error( error )
{
}

QString Spotify::Error::toString() const
{
    return QString( sp_error_message( m_error ) );
}

bool Spotify::Error::isError() const
{
    return ( m_error != SP_ERROR_OK );
}
