//SettingsDialog.h: Header file for the SettingsDialog class (dialog for management of client-related settings).

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QDebug>
#include <QSettings>
#include <QGroupBox>
#include <QLabel>
#include <QLineEdit>
#include <QCheckBox>
#include <QScrollArea>
#include <QPushButton>
#include <QGridLayout>

//defines for default setting values

#define MAX_TRACKS_DEFAULT  500
#define MAX_ALBUMS_DEFAULT 10
#define MAX_ARTISTS_DEFAULT 10
#define MIN_BUFFER_LEN_DEFAULT  30
#define PRE_BUFFERING_DEFAULT    1
#define ENABLE_SCROBBLING_DEFAULT 0

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:

    SettingsDialog(QSettings* pSettings, QWidget* pParent = 0); //default contructor

    ~SettingsDialog(); //destructor

     void readSettings(); //read and set current settings

private:

    QSettings* m_pAppSettings; //app settings instance

    QGridLayout m_MainLayout; //dialog main layout

    QScrollArea m_MainArea; //main scrollarea

    QWidget m_MainAreaLayout; //layout containing main scrollarea

    QGridLayout m_GridLayout; //elements contained within the main scrollarea

    QGroupBox m_SearchOptions; //container for search related settings

    QGridLayout m_SearchOptionLayout;

    QGroupBox m_BufferingOptions; //container for settings related to buffering

    QGridLayout m_BufferingOptionLayout;

    QGroupBox m_ScrobblingOptions; //container for settings related to Last.fm scrobbling

    QGridLayout m_ScrobblingOptionLayout;

    QLabel m_maxSearchTracksCaption;
    QLineEdit m_maxSearchTracksInput; //max. tracks returned by search

    QLabel m_maxSearchAlbumsCaption;
    QLineEdit m_maxSearchAlbumsInput; //max. albums returned by search

    QLabel m_maxSearchArtistsCaption;
    QLineEdit m_maxSearchArtistsInput; //max. artists returned by search

    QLabel m_MinBufferLenCaption;
    QLineEdit m_MinBufferLenInput;  //min. buffer length used (in secs)

    QCheckBox m_PreBufferNextTrackSelection; //selected if automatic buffering of next track should be activated

    QCheckBox m_EnableScrobblingSelection; //enable / disable scrobbling to Last.Fm

    QLabel m_LastFMUserIDCaption;
    QLineEdit m_LastFMUserIDInput;  //Last.Fm User ID input

    QLabel m_LastFMPasswordCaption;
    QLineEdit m_LastFMPasswordInput;  //Last.Fm password input

    QPushButton m_SaveSettingsBtn; //Save current settings button

    //members holding current settings

    qint32 m_maxSearchTracks;

    qint32 m_maxSearchAlbums;

    qint32 m_maxSearchArtists;

    qint32 m_minBufferLen;

    qint32 m_preBufferingActive;

    qint32 m_enableScrobbling;

    QString m_strLastFMUserID;

    QString m_strLastFMPassword;

    void saveSettings(); //save (modified) settings

private slots:

    void OnSaveSettingsBtn();
    void OnScrobblingStateChanged(int newState);

signals:

    void settingsSaved(); //signal emitted when some setting has been changed

};

#endif // SETTINGSDIALOG_H
