#include <QDebug>
#include "artistcatalogue.h"
#include "artist.h"
#include "track.h"
#include "album.h"

namespace Spotify
{
    ArtistCatalogue::ArtistCatalogue( sp_artistbrowse* ab, QObject* parent ):
            Spotify::TrackCollection( parent ),
            m_artistbrowse( ab ),
            m_artist( 0 )
    {
        // Impclitily reffed by sp_artistbrowse_create()
    }

    bool ArtistCatalogue::load()
    {
        if( !m_artistbrowse ) return false;

        // Only trigger this once, libspotify guarantees metadata is ready
        if( m_artistbrowse && sp_artistbrowse_is_loaded( m_artistbrowse ) && !m_isLoaded )
        {
            // Set artist:
            if( !m_artist )
            {
                m_artist = new Spotify::Artist( sp_artistbrowse_artist( m_artistbrowse ), false, this );
                if( !m_artist->isLoaded() && !m_artist->load() )
                {
                    qDebug() << "Unable to load artist..";
                    return false;
                }
            }

            // Set portraits:
            if( m_portraits.isEmpty() )
            {
                int numPortraits = sp_artistbrowse_num_portraits( m_artistbrowse );
                for( int i = 0; i < numPortraits; ++i )
                {
                    m_portraits.append( sp_artistbrowse_portrait( m_artistbrowse, i) );
                }
            }

            // Set tracks:
            if( m_tracks.isEmpty() )
            {
                int numTracks = sp_artistbrowse_num_tracks( m_artistbrowse );
                for( int i = 0; i < numTracks; ++i )
                {
                    sp_track* sptrack = sp_artistbrowse_track( m_artistbrowse, i );
                    Spotify::Track* track = new Spotify::Track( sptrack, false, this );
                    addTrack( track );

                    // Tracks should be loaded:
                    if( !track->isLoaded() && !track->load() )
                        return false;
                }
            }

            if( m_similarArtists.isEmpty() )
            {
                int numSimilarArtists = sp_artistbrowse_num_similar_artists( m_artistbrowse );
                for( int i = 0; i < numSimilarArtists; ++i )
                {
                    sp_artist* spartist = sp_artistbrowse_similar_artist( m_artistbrowse, i );
                    Spotify::Artist* artist = new Spotify::Artist( spartist, false, this );
                    m_similarArtists.append( artist );

                    // Artists should be loaded:
                    if( !artist->isLoaded() && !artist->load() )
                        return false;
                }
            }

            if( m_biography.isEmpty() )
            {
                const char* charData = sp_artistbrowse_biography( m_artistbrowse );
                m_biography = QString::fromUtf8( charData, strlen( charData ) );
            }

            //load list of artist albums

            m_AlbumList.clear();

            for(int albumPos = 0; albumPos < sp_artistbrowse_num_albums(m_artistbrowse); albumPos++)
            {
                Spotify::Album* pAlbum = new Spotify::Album(sp_artistbrowse_album(m_artistbrowse,albumPos),false,this);
                m_AlbumList.append(pAlbum);
            }

            m_isLoaded = true;
            emit loaded();
        }
        return m_isLoaded;
    }

    ArtistCatalogue::~ArtistCatalogue()
    {
        qDebug() << "Artist catalogue deleted along with " << this->children().count() << " children";

        if( m_artistbrowse )
            sp_artistbrowse_release( m_artistbrowse );
    }

} // namespace Spotify
