//QueueView.h: Header file for the QueueView class (implements the queue  / Now Playing view)
#ifndef QUEUEVIEW_H
#define QUEUEVIEW_H

#include <QtGui/QWidget>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#include <QtGui/QImage>
#include <QtGui/QBitmap>
#include <QtGui/QMainWindow>
#include <QtGui/QGridLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QListView>
#include <QStandardItemModel>
#include <QItemSelectionModel>
#include <QModelIndex>
#include <QStandardItem>
#include <QDebug>
#include <QScrollBar>
#include <QTextStream>
#include <QtGui/QPixmap>
#include <QMaemo5InformationBox>
#include <qspotify_src/spotifysession.h>
#include "CustomSlider.h"
#include "SpectrumAnalyzer.h"
#include "ListViewDelegate.h"

class QueueView : public QMainWindow
{
    Q_OBJECT

public:

    QueueView(Spotify::Session* pSession, QWidget* parent = 0); //constructor
    ~QueueView();

    void setNowPlaying(QList<Spotify::Track*> queue, int currQueuePos, bool playing, qint64 currPlaybackPos = 0, qint64 currBufPos = 0, bool doShuffle = false, qint32 currShufflePos=-1);

    void setActive(bool active, bool shuffleActive=false); //set whether the current instance is active (i.e., whether signals should be processed)

    bool getShuffleActive();

private:

    QWidget m_MainLayout;

    QGridLayout m_GridLayout;

    QGridLayout m_PlayControls;

    QLabel m_AlbumCoverContainer;

    QLabel m_ArtistName;

    QImage m_AlbumCoverPic; //current album cover (for selected track)

    QPushButton m_PauseResumeBtn; //pause / resume

    QPushButton m_PrevBtn; //prev track

    QPushButton m_NextBtn; //next track

    QPushButton m_ShuffleBtn; //shuffle tracks

    CustomSlider* m_pProgressSlider; //track progress indicator / slider

    SpectrumAnalyzer* m_pSpectrum; //spectrum (active during audio playback)

    QListView* m_pTrackInfoView;

    QStandardItemModel *m_pTrackInfoModel;

    ListViewDelegate *m_pTrackInfoDelegate;

    Spotify::Session* m_pSession; //Spotify session instance

    Spotify::Track* m_pCurrTrack; //currently playing track in queue

    bool m_Shuffle; //TRUE in case shuffle function enabled

    qint32 m_currShufflePos; //current position in the shuffle queue

    qint32 m_currQueuePos; //current position in play queue

    qint32 m_currTrackDuration; //current track duration (in secs)

    QList<Spotify::Track*> m_PlayQueue; //current play queue

    QList<qint32> m_ShuffleQueue; //list holds random track positions (used by shuffle function)

    bool m_Active; //TRUE in case current queueview instance is active (i.e., handles signals)

    bool m_UpdateBufPos; //TRUE in case buffering position should be updated

    void addTracks(QList<Spotify::Track*> trackList); //add tracks from specified tracklist to main listview

    void loadTrackData(Spotify::Track* track); //load data for specified track, e.g., album cover art

    void clearViewSelection(); //clear the current view selection (i.e., set to state when no track is active)

    void shuffleQueue(); //shuffle the current playqueue (the m_ShuffleQueue contains the shuffled queue positions)


private slots:

    void OnTrackActivated(QModelIndex index);
    void OnPauseResumeToggle();
    void OnShuffleToggle();
    void OnTrackPosUpdated(qint64 trackPos);
    void OnPlaybackPositionUpdated(qint64 trackPos);
    void OnAlbumCoverReady(QImage image);
    void OnTrackPlaybackFinished();
    void OnPlayingState(bool state);
    void OnNextTrackBtn();
    void OnPrevTrackBtn();
    void OnBufferNextTrack();

signals:

    void playQueuePosUpdated(qint32, qint32); //signal emitted when position in playqueue has been updated

};

#endif // QUEUEVIEW_H
