//MainWindow.h: Header file for the track view class (default playlist / search result / album view).

#ifndef TRACKVIEW_H
#define TRACKVIEW_H

#include <QtGui/QWidget>
#include <QMainWindow>
#include <QtGui/QVBoxLayout>
#include <QAction>
#include <QMenuBar>
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QStringList>
#include <QDebug>
#include <QCloseEvent>
#include <QMaemo5InformationBox>
#include <QHeaderView>
#include <QScrollBar>
#include <qspotify_src/spotifysession.h>
#include "QueueView.h"

//sorting related defines

//sort columns
#define COLUMN_TRACK 0
#define COLUMN_ARTIST 1
#define COLUMN_ALBUM 2

//sort orders
#define SORT_ORIGINAL -1
#define SORT_ASCENDING 0
#define SORT_DECENDING 1


class TrackView : public QMainWindow
{
    Q_OBJECT

public:
    TrackView(Spotify::Session* pSession, QWidget *parent = 0);
    ~TrackView();

    void setPlaylist(Spotify::Playlist* pPlaylist); //set the playlist for which tracks should be displayed
    void setSearchResults(Spotify::Search* pSearch); //set the search results to be displayed

protected:

    void closeEvent(QCloseEvent* evt);

private:

    QWidget m_MainLayout;

    QGridLayout m_GridLayout;

    QVBoxLayout m_Layout;

    Spotify::Session* m_pSession;

    Spotify::Playlist* m_pPlaylist;

    QList<Spotify::Track*> m_TrackList; //list of tracks returned by e.g., search and contained in playlist

    QueueView *m_pQueueView;

    QAction *m_pActSortByPopularity;

    QTableWidget m_TrackInfo;

    qint32 m_currSortCol; //current sort column
    qint32 m_currSortOrder; //current sort order

    void addTracks(Spotify::Playlist* playlist); //add playlist tracks to main tableview

    void addTracks(QList<Spotify::Track*> trackList); //add tracks from specified tracklist to main tableview

    void setPlayQueue(); //set playqueue (i.e., add all tracks from selected track to last track in list to playqueue)

private slots:

    void OnTrackActivated(QTableWidgetItem* trackItem);
    void OnPlayQueuePosUpdated(qint32 pos);
    void OnHeaderClicked(int logicalIndex);
    void OnSortByPopularityTriggered(bool checked);

signals:

    void playQueueSet(QList<Spotify::Track*>); //signal emitted upon playqueue set
    void playQueuePosUpdated(qint32); //signal emitted when position in playqueue has been updated
    void activeQueueViewChanged(bool); //signal emitted when active queueview changed (param is TRUE in case TrackView instance is active)
};

#endif // TRACKVIEW_H
