#include <QPainter>
#include <QTimer>
#include "SpectrumAnalyzer.h"

SpectrumAnalyzer::SpectrumAnalyzer(QWidget *parent, int width, int height)
	: QWidget(parent)
{
	m_width = width;
	m_height = height;
	
	m_p1 = height;
	m_p2 = height;
	m_p3 = height;
	m_p4 = height;

	m_playing=false;

	this->setFixedSize(m_width, m_height);
	m_color = QColor(0, 0, 0);

	QTimer *timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), this, SLOT(updateAnalyzers()));
	timer->start(50);}

SpectrumAnalyzer::~SpectrumAnalyzer()
{

}

void SpectrumAnalyzer::paintEvent(QPaintEvent *)
{
	QPainter painter(this);
	painter.setRenderHint(QPainter::Antialiasing);

	painter.setPen(Qt::NoPen);

	painter.setBrush(m_color);
	painter.drawRect(QRect(0, m_p1, m_width/6, m_height-m_p1));
	painter.drawRect(QRect(m_width/4, m_p2, m_width/6, m_height-m_p2));
	painter.drawRect(QRect((2*m_width)/4, m_p3, m_width/6, m_height-m_p3));
	painter.drawRect(QRect((3*m_width)/4, m_p4, m_width/6, m_height-m_p4));
}

void SpectrumAnalyzer::setColor(QColor color) 
{
	m_color=color;
}

void SpectrumAnalyzer::updateAnalyzers() 
{
	int pos;
	int speed = m_height/3;

	if(m_playing) {
		pos = (rand()%speed)-(speed/2);
		m_p1+=pos;
		if(m_p1<0) m_p1 = 0;
		if(m_p1>m_height) m_p1 = m_height;

		pos = (rand()%speed)-(speed/2);
		m_p2+=pos;
		if(m_p2<0) m_p2 = 0;
		if(m_p2>m_height) m_p2 = m_height;

		pos = (rand()%speed)-(speed/2);
		m_p3+=pos;
		if(m_p3<0) m_p3 = 0;
		if(m_p3>m_height) m_p3 = m_height;

		pos = (rand()%speed)-(speed/2);
		m_p4+=pos;
		if(m_p4<0) m_p4 = 0;
		if(m_p4>m_height) m_p4 = m_height;
	} else {
		m_p1 = m_height-1;
		m_p2 = m_height-1;
		m_p3 = m_height-1;
		m_p4 = m_height-1;
	}

	update();
}

void SpectrumAnalyzer::mousePressEvent(QMouseEvent *event)
 {
     if (event->button() == Qt::LeftButton) {
		emit clicked();
     }
 }

