#include "user.h"

namespace Spotify
{
    User::User(sp_user* user, QObject *parent):
            QObject(parent),
            m_user( user ),
            m_loaded( false )
    {
        if( m_user )
            load();
    }

    bool User::load()
    {
        if( !m_user ) return false;

        if( m_user )
        {
            const char* charData;

            charData = sp_user_canonical_name( m_user );
            m_canonicalName = QString::fromUtf8( charData, strlen( charData ) );

            charData = sp_user_display_name( m_user );
            m_displayName = QString::fromUtf8( charData, strlen( charData ) );
            m_loaded = true;
            emit loaded();
        }
        return m_loaded;
    }

    User::~User()
    {
    }

} // namespace Spotify
