#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "importevents.h"
#include "spinboxdelegate.h"
#include "teamrooster.h"
#include "numerictablewidgetitem.h"
#include <QSqlQuery>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlRecord>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QSqlQueryModel>
#include <QMenuBar>
#include <QMessageBox>
#include <QUrl>
#include <QWebFrame>
#include <QTreeWidgetItem>
#include <QPlastiqueStyle>
#include <QXmlQuery>
#include <QXmlResultItems>
#include <QtNetwork>
//#include <QPropertyAnimation>
#include <QMutableHashIterator>

QString sSelectedGroup = "";
QString sSelectedRound = "All";
QString sSelectedSport  = "";
QString sSelectedRegion = "";
QString sSelectedEvent = "";
QString sSelectedSeason = "";
QString sSelectedURL = "";
QString sSelectedTeam = "";
int iSelectedSoccerDBID;
importevents *dlgImportEvents;
QHash<QString, int> hGroups;
QHash<QString, int> hTeams;
QHash<QString, int> hSportType;
bool isLeagueListPopulated = false;
bool isFavouritesListPopulated;
bool isChatLoaded = false;
bool isPredictLoaded = false;

struct Standing {
    int iTeamRowID;
    QString sTeamName;
    int iPoints;
    int iWins;
    int iDraws;
    int iLosses;
    int iScored;
    int iConceeded;
} stStanding;

class NumericTableWidgetItem :
         public QTableWidgetItem
{
public:
        NumericTableWidgetItem():QTableWidgetItem()    {}
        bool operator <(const QTableWidgetItem& theItem) const
        {
                return this->text().toInt() < theItem.text().toInt();
        }
};


QHash<int, Standing> hStanding;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{

    ui->setupUi(this);
    loadMenu();
    ui->lblLoading->setVisible(false);

    isLeagueListPopulated = false;
    if (existDatabase())
    {
//        ui->tabWidget->tabBar()->setStyleSheet();
        ui->tabWidget->removeTab(10); //remove tab_TeamRooster
        ui->tabWidget->removeTab(7); //remove tab_UpdateScores
        ui->tabWidget->removeTab(4); //remove tab_OnlineMatches

        ui->webView_Chat->settings()->setAttribute(QWebSettings::PluginsEnabled, true);
//        ui->webView_Chat->settings()->setAttribute(QWebSettings::JavascriptCanOpenWindows, true);
        ui->webView_OnlineTable->settings()->setAttribute(QWebSettings::JavascriptEnabled, true);
        ui->webView->settings()->setAttribute(QWebSettings::JavascriptEnabled, true);
        ui->webView_LiveScore->settings()->setAttribute(QWebSettings::AutoLoadImages, false);
        ui->webView->setStyle(new QPlastiqueStyle);
        ui->webView_OnlineTable->setStyle(new QPlastiqueStyle);
        ui->twFavourites->setStyle(new QPlastiqueStyle);
        ui->twSelect->setStyle(new QPlastiqueStyle);
        ui->txtHomeTeam->setStyle(new QPlastiqueStyle);
        ui->txtAwayTeam->setStyle(new QPlastiqueStyle);
        ui->twGames->setStyle(new QPlastiqueStyle);
        ui->twStandings->setStyle(new QPlastiqueStyle);
        ui->cbRounds->setStyle(new QPlastiqueStyle);
        ui->cbTeam->setStyle(new QPlastiqueStyle);
        ui->cbSeason->setStyle(new QPlastiqueStyle);
        ui->webView->setProperty("FingerScrollable", true);
        ui->webView_OnlineTable->setProperty("FingerScrollable", true);
        ui->webView_UpdateScores->setProperty("FingerScrollable", true);
        ui->webView_URL->setProperty("FingerScrollable", true);
        ui->twSelect->setProperty("FingerScrollable", true);
        ui->twFavourites->setProperty("FingerScrollable", true);
        ui->twGames->setProperty("FingerScrollable", true);
        ui->twStandings->setProperty("FingerScrollable", true);
    }

    ui->twFavourites->horizontalHeader()->setResizeMode(0,QHeaderView::ResizeToContents);
    ui->twFavourites->horizontalHeader()->setResizeMode(1,QHeaderView::ResizeToContents);
    ui->twFavourites->horizontalHeader()->setResizeMode(2,QHeaderView::ResizeToContents);
    ui->twFavourites->horizontalHeader()->setResizeMode(3,QHeaderView::ResizeToContents);
    ui->twFavourites->horizontalHeader()->setResizeMode(4,QHeaderView::ResizeToContents);

//    ui->twStandings->verticalHeader()->setResizeMode(0,QHeaderView::ResizeToContents);
    ui->twStandings->horizontalHeader()->setResizeMode(0,QHeaderView::ResizeToContents);
    ui->twStandings->horizontalHeader()->setResizeMode(1,QHeaderView::ResizeToContents);
    ui->twStandings->horizontalHeader()->setResizeMode(2,QHeaderView::ResizeToContents);
    ui->twStandings->horizontalHeader()->setResizeMode(3,QHeaderView::ResizeToContents);
    ui->twStandings->horizontalHeader()->setResizeMode(4,QHeaderView::ResizeToContents);
    ui->twStandings->horizontalHeader()->setResizeMode(5,QHeaderView::ResizeToContents);
    ui->twStandings->horizontalHeader()->setResizeMode(6,QHeaderView::ResizeToContents);
    ui->twStandings->horizontalHeader()->setResizeMode(7,QHeaderView::ResizeToContents);

//    ui->twGames->verticalHeader()->setResizeMode(0,QHeaderView::ResizeToContents);
    ui->twGames->horizontalHeader()->setResizeMode(0,QHeaderView::ResizeToContents);
    ui->twGames->horizontalHeader()->setResizeMode(1,QHeaderView::ResizeToContents);
    ui->twGames->horizontalHeader()->setResizeMode(2,QHeaderView::ResizeToContents);
    ui->twGames->horizontalHeader()->setResizeMode(3,QHeaderView::ResizeToContents);

    connect(ui->twSelect,SIGNAL(itemClicked(QTreeWidgetItem*,int)),this,SLOT(showSelectedEvent(QTreeWidgetItem*)));

    connect(ui->vsFromRound,SIGNAL(valueChanged(int)),this,SLOT(fromRoundChanged(int)));
    connect(ui->vsToRound,SIGNAL(valueChanged(int)),this,SLOT(toRoundChanged(int)));

    setCustomStyleSheets();
    populateSelect();
    populateFavourites();
    if (sSelectedSport == "Football")
    {
        ui->tabWidget->setCurrentWidget(ui->tab_OfflineMatches);
    }
    else
    {
        ui->tabWidget->setCurrentWidget(ui->tab_News);
    }

}

void MainWindow::showOnlineTable()
{
    QPalette palette;
    QString sHTML;

    QString sStyle;

    sStyle = "<style type='text/css'>"
    ".Date "
    "{"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        font-size: 30px;"
    "        padding: 2px;"
    "        margin: 5px;"
    "}"
    ".Match "
    "{"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        font-size: 30px;"
    "        color: black; "
    "        border-width: 1px;"
    "        border-style: solid;"
    "        border-color: #0000FF;"
    "        margin: 2px;"
    "        padding: 2px 1px;"
    "        -webkit-border-radius: 5px;"
    "}"
    ".header {"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        font-weight: bold;"
    "        font-size: 28px;"
    "        padding: 2px;    }"
    ".odd {"
    "        background-color: #ebebeb;"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        font-size: 28px;"
    "        padding: 2px;    }"
    ".even {"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        font-size: 28px;"
    "        padding: 2px;    }"
    ".lines {background-color: #000;}"
    ".highlight {font-weight: bold;}"
    "</style>";



    ui->webView_OnlineTable->settings()->setAttribute(QWebSettings::JavascriptEnabled, true);
    sHTML = "<HTML>" + sStyle + "<body><script type='text/javascript' src='http://www.aragon.ws/soccerdb/gettable.php?id=" +     QString::number(iSelectedSoccerDBID) + "&&showHeader=true&cssHeader=header&cssLines=lines&css1=odd&css2=even'></script>";
    sHTML.append("<p><a href='http://www.1-goal.org'><img src=':/images/pictures/resource/pictures/1goal.jpg'></a></p>");
//    "<a href='http://www.1-goal.org'><img src='1goal.jpg' alt='1GOAL'>"
    sHTML.append("</body></HTML>");
    palette = ui->webView_OnlineTable->palette();
    palette.setBrush(QPalette::Base, Qt::transparent);
    ui->webView_OnlineTable->page()->setPalette(palette);
    ui->webView_OnlineTable->setAttribute(Qt::WA_OpaquePaintEvent, false);
    ui->webView_OnlineTable->setAttribute(Qt::WA_TranslucentBackground, true);
    ui->webView_OnlineTable->setHtml(sHTML, QUrl("qrc:/"));
//    ui->webView_OnlineTable->setHtml(sHTML, QUrl::fromLocalFile(path));
    ui->webView_OnlineTable->show();

}

void MainWindow::fromRoundChanged(int iValue)
{
    int iOldFrom;
    iOldFrom = ui->txtFrom->text().toInt();
    if (iOldFrom != iValue)  //Avoid unnecessary updates when nothing has changed.
    {
        ui->vsToRound->setMinimum(iValue);
        ui->txtFrom->setText(QString::number(iValue));
        showStandings();
    }
}

void MainWindow::toRoundChanged(int iValue)
{
    int iOldTo;
    iOldTo = ui->txtTo->text().toInt();
    if (iOldTo != iValue)  //Avoid unnecessary updates when nothing has changed.
    {
        ui->vsFromRound->setMaximum(iValue);
        ui->txtTo->setText(QString::number(iValue));
        showStandings();
    }
}

void MainWindow::setCustomStyleSheets()
{
        // NOTE: We have to store database file into user home folder in Linux
//            QString path(QDir::home().path());
    QString sUserPath;

#ifdef Q_OS_LINUX
        sUserPath = QDir::home().path().append(QDir::separator()).append(".qsportsevent").append(QDir::separator()).append("user").append(QDir::separator());
//        path = QDir::toNativeSeparators(path);
#else
        sUserPath = QDir::currentPath().append(QDir::separator());
#endif
    sUserPath = QDir::toNativeSeparators(sUserPath);

    QString sCSSMatches, sCSSTable, sCSSFavourites, sCSSSelect, sCSSNews ;

    sCSSMatches = sUserPath + "matches.css";
    sCSSTable = sUserPath + "table.css";
    sCSSFavourites = sUserPath + "favourites.css";
    sCSSSelect = sUserPath + "select.css";
    sCSSNews = sUserPath + "news.css";

    QFile sCSSFile;
    if (QFile::exists(sCSSMatches))
    {
        sCSSFile.setFileName(sCSSMatches);
        sCSSFile.open(QIODevice::ReadOnly);
        ui->twGames->setStyleSheet(QString(sCSSFile.readAll()));
        sCSSFile.close();
    }

    if (QFile::exists(sCSSTable))
    {
        sCSSFile.setFileName(sCSSTable );
        sCSSFile.open(QIODevice::ReadOnly);
        ui->twStandings->setStyleSheet(QString(sCSSFile.readAll()));
        sCSSFile.close();
    }

    if (QFile::exists(sCSSFavourites ))
    {
        sCSSFile.setFileName(sCSSFavourites );
        sCSSFile.open(QIODevice::ReadOnly);
        ui->twFavourites->setStyleSheet(QString(sCSSFile.readAll()));
        sCSSFile.close();
    }

    qDebug() << sCSSSelect;
    if (QFile::exists(sCSSSelect))
    {
        sCSSFile.setFileName(sCSSSelect);
        sCSSFile.open(QIODevice::ReadOnly);
        ui->twSelect->setStyleSheet(QString(sCSSFile.readAll()));
        qDebug() << ui->twSelect->styleSheet();
        sCSSFile.close();
    }

    if (QFile::exists(sCSSNews))
    {
        sCSSFile.setFileName(sCSSNews);
        sCSSFile.open(QIODevice::ReadOnly);
        ui->webView_URL->setStyleSheet(QString(sCSSFile.readAll()));
        sCSSFile.close();
    }
}

void MainWindow::showSelectedEvent2()
{
    if (sSelectedSport == "Football")
    {
//        populateSeason(sSelectedSeason);
        populateSeasonCombo(sSelectedSport, sSelectedRegion, sSelectedEvent);
        ui->tab_UpdateScores->setEnabled(true);
        ui->tab_OfflineMatches->setEnabled(true);
        ui->tab_OfflineTable->setEnabled(true);
        ui->tab_OnlineTable->setEnabled(true);
        this->setWindowTitle("MobiTifo - " + sSelectedEvent);
    }
    else
    {
//        showLiveScores();
        ui->tab_UpdateScores->setEnabled(false);
        ui->tab_OfflineMatches->setEnabled(false);
        ui->tab_OfflineTable->setEnabled(false);
        ui->tab_OnlineTable->setEnabled(false);

        this->setWindowTitle("MobiTifo - " + sSelectedSport + " - " + sSelectedRegion);
    }
  //  ui->tabWidget->setCurrentWidget(ui->tab_LiveScore);

}

void MainWindow::showSelectedEvent(QTreeWidgetItem *qtwiSelected)
{
    if (qtwiSelected->type() == typeEvent)
    {
        sSelectedEvent = qtwiSelected->text(0);
        sSelectedRegion = qtwiSelected->parent()->text(0);
        sSelectedSport = hSportType.key(qtwiSelected->parent()->parent()->type());
        qDebug() << sSelectedSport ;
        showSelectedEvent2();
    }
}

void MainWindow::showLiveScores()
{
    QString sLiveScoresURL;
    ui->webView_LiveScore->page()->mainFrame()->setScrollBarPolicy(Qt::Horizontal,
                                                                       Qt::ScrollBarAlwaysOn);
    ui->webView_LiveScore->page()->mainFrame()->setScrollBarPolicy(Qt::Vertical,
                                                                       Qt::ScrollBarAlwaysOn);

    if (sSelectedSport == "Football")
    {
        if (sSelectedEvent.contains("World Cup"))
        {
            sLiveScoresURL = "http://www.livescore.in/world-cup/";
        }
        else if (sSelectedEvent.contains("Champions"))
        {
            sLiveScoresURL = "http://www.livescore.in/european-cups/";
        }
        else
        {
            sLiveScoresURL = "http://www.livescore.in/" + sSelectedRegion.toLower() +"/";
        }
    }
    else
    {
        sLiveScoresURL = "http://www.livescore.in/" + sSelectedSport.toLower() + "/" + sSelectedRegion.toLower() + "/";
    }

    // Only reload if a new URL is requested.
    if (ui->webView_LiveScore->url() != QUrl(sLiveScoresURL))
    {
        ui->webView_LiveScore->setUrl(sLiveScoresURL);
        qDebug() << ui->webView_LiveScore->url();
        ui->webView_LiveScore->show();
        qDebug() << ui->webView_LiveScore->page()->mainFrame()->toHtml();
    }
}

void MainWindow::showOnlineLeague(int iSelectedSoccerDBID)
{
    QString sHTML;
    QString sSelectedSoccerDBID;
    QString sStyle;
    QPalette palette;
    QString path;
    sSelectedSoccerDBID.setNum(iSelectedSoccerDBID);

    this->setWindowTitle("MobiTifo - " + sSelectedEvent);


#ifdef Q_OS_LINUX
        // NOTE: We have to store database file into user home folder in Linux
        path = QDir::home().path();
#else
        path = QDir::currentPath();
        qDebug() << path;
        // NOTE: File exists in the application private folder, in Symbian Qt implementation
#endif

        showLiveScores();
/*
    sHTML = "<HTML>" + sStyle + "<body><script type='text/javascript' src='http://www.aragon.ws/soccerdb/getmatches.php?id=" + sSelectedSoccerDBID + "&date=latest&css=Match&cssDate=Date'></script>"
            "<a href='http://www.1-goal.org'><img src='1goal.jpg' alt='1GOAL'></a>"
            "</body></HTML>";
//    qDebug() << "sHTML :" << sHTML ;

    palette = ui->webView->palette();
    palette.setBrush(QPalette::Base, Qt::transparent);
    ui->webView->page()->setPalette(palette);
    ui->webView->setAttribute(Qt::WA_OpaquePaintEvent, false);
    ui->webView->setAttribute(Qt::WA_TranslucentBackground, true);
    qDebug() << QUrl::fromLocalFile(path);
    ui->webView->setHtml(sHTML, QUrl::fromLocalFile(path));
//    ui->webView->page()->
    ui->webView->show();
//    qDebug() << "webView:" << ui->webView->page()->mainFrame()->toHtml();
*/

    showOnlineTable();

    ui->webView_URL->settings()->setAttribute(QWebSettings::JavascriptEnabled, true);
}

void MainWindow::on_pbDumpHTML_clicked()
{
    QString sHTML;

//    qDebug() << ui->webView_LiveScore->page()->mainFrame()->toHtml();
    sHTML.append("Main Frame");
    sHTML.append(ui->webView_LiveScore->page()->mainFrame()->toHtml());

    for (int i=0; i<ui->webView_LiveScore->page()->mainFrame()->childFrames().count(); i++)
    {
//        qDebug() << ui->webView_LiveScore->page()->mainFrame()->childFrames().at(i)->toHtml();
        sHTML.append("Frame Number : " + QString::number(i));
        qDebug() << "Frame Number : " + QString::number(i);
        sHTML.append( ui->webView_LiveScore->page()->mainFrame()->childFrames().at(i)->toHtml());
        qDebug() << ui->webView_LiveScore->page()->mainFrame()->childFrames().at(i)->toHtml();

        for (int j=0; j<ui->webView_LiveScore->page()->mainFrame()->childFrames().at(i)->childFrames().count(); j++)
        {
            sHTML.append("Frame Number : " + QString::number(i) + " - " + QString::number(j));
            qDebug() << "Frame Number : " + QString::number(i) + " - " + QString::number(j);
            sHTML.append( ui->webView_LiveScore->page()->mainFrame()->childFrames().at(i)->childFrames().at(j)->toHtml());
            qDebug() << ui->webView_LiveScore->page()->mainFrame()->childFrames().at(i)->childFrames().at(j)->toHtml();


            for (int k=0; k<ui->webView_LiveScore->page()->mainFrame()->childFrames().at(i)->childFrames().at(j)->childFrames().count(); j++)
            {
                sHTML.append("Frame Number : " + QString::number(i) + " - " + QString::number(j) + " - " + QString::number(k));
                qDebug() << "Frame Number : " + QString::number(i) + " - " + QString::number(j) + " - " + QString::number(k);
                sHTML.append( ui->webView_LiveScore->page()->mainFrame()->childFrames().at(i)->childFrames().at(j)->childFrames().at(k)->toHtml());
                qDebug() << ui->webView_LiveScore->page()->mainFrame()->childFrames().at(i)->childFrames().at(j)->childFrames().at(k)->toHtml();

            }


        }
    }
    qDebug() << sHTML;
}

void MainWindow::on_webView_LiveScore_loadFinished(bool ok)
{
    QWebFrame *wfMain;

    wfMain = ui->webView_LiveScore->page()->mainFrame();
    wfMain->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOn);
    wfMain->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOn);
    qDebug() << wfMain->scrollBarMinimum(Qt::Horizontal);
    qDebug() << wfMain->scrollBarMaximum(Qt::Horizontal);
    qDebug() << wfMain->scrollBarMinimum(Qt::Vertical);
    qDebug() << wfMain->scrollBarMaximum(Qt::Vertical);
//    wfMain->setScrollBarValue(Qt::Horizontal, 190);
//    wfMain->setScrollBarValue(Qt::Vertical, 285);

}

void MainWindow::on_webView_Chat_loadFinished(bool ok)
{
    QWebFrame *wfMain;
    wfMain = ui->webView_Chat->page()->mainFrame();
    wfMain->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOn);
    wfMain->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOn);
    wfMain->setScrollBarValue(Qt::Horizontal, 300);
    wfMain->setScrollBarValue(Qt::Vertical, 160);
}

void MainWindow::on_webView_Predict_loadFinished(bool ok)
{
    QWebFrame *wfMain;
    wfMain = ui->webView_Predict->page()->mainFrame();
    wfMain->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOn);
    wfMain->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOn);
    wfMain->setScrollBarValue(Qt::Horizontal, 160);
    wfMain->setScrollBarValue(Qt::Vertical, 300);
}

void MainWindow::showURL()
{
    QString sHTML;
    QPalette palette;
    QFile queryFile;
    QString sXSLTPath;
    QNetworkAccessManager manager;
    QEventLoop loop;
    QString sXMLFile;
    QString sHTMLFile;

    //    return; //Temporary while testing!
    if (!sSelectedURL.isEmpty())
    {

#ifdef Q_OS_LINUX
        sXSLTPath = QDir::home().path();
        sXSLTPath.append(QDir::separator()).append(".qsportsevent").append(QDir::separator()).append("user").append(QDir::separator()).append("rss.xsl");
        sXMLFile = QDir::home().path();
        sXMLFile.append(QDir::separator()).append(".qsportsevent").append(QDir::separator()).append("rss.xml");
        sHTMLFile = QDir::home().path();
        sHTMLFile.append(QDir::separator()).append(".qsportsevent").append(QDir::separator()).append("tmp.html");
#else
        sXSLTPath = QDir::currentPath().append(QDir::separator()).append("rss.xsl");
        sXMLFile = QDir::currentPath().append(QDir::separator()).append("rss.xml");
        sHTMLFile = QDir::currentPath().append(QDir::separator()).append("tmp.html");
        // NOTE: File exists in the application private folder, in Symbian Qt implementation
#endif
        sXSLTPath = QDir::toNativeSeparators(sXSLTPath);
        qDebug() << sXSLTPath;
        sXMLFile = QDir::toNativeSeparators(sXMLFile);
        qDebug() << sXMLFile;
        sHTMLFile = QDir::toNativeSeparators(sHTMLFile);
        qDebug() << sHTMLFile;

        QString sXSL;
        sXSL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
        "<xsl:stylesheet version=\"2.0\" "
        " xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" "
        " xmlns=\"http://www.w3.org/1999/xhtml\">"
        "<xsl:output method=\"xhtml\"/>"
        "<xsl:output method=\"text\" name=\"textFormat\"/>"
         "<xsl:template match=\"/\">"
          "<html>"
           "<body>"
            "<table>"
             "<tr>"
              "<td><xsl:value-of select=\"pubDate\"/></td>"
              "<td><xsl:value-of select=\"title\"/></td>"
             "</tr>"
            "</table>"
           "</body>"
          "</html>"
         "</xsl:template>"
        "</xsl:stylesheet>";

        QXmlQuery qry( QXmlQuery::XSLT20 );
        qDebug() << sSelectedURL;
        QFile fXMLFile( sXMLFile );
        fXMLFile.open(QIODevice::WriteOnly);

        QNetworkReply *reply = manager.get( QNetworkRequest(QUrl(sSelectedURL)));
        QObject::connect(reply, SIGNAL(finished()), &loop, SLOT(quit()));

        loop.exec();
        fXMLFile.write(reply->readAll());
        fXMLFile.close();
        delete reply;
        fXMLFile.open(QIODevice::ReadOnly);

        qry.setFocus(&fXMLFile);
        fXMLFile.close();
        QFile fXSLTFile( sXSLTPath );
        fXSLTFile.open(QIODevice::ReadOnly);
        qry.setQuery( &fXSLTFile );
        fXSLTFile.close();

        QString resultBuffer;
        qry.evaluateTo( &resultBuffer );
        qDebug() << resultBuffer;
        ui->webView_URL->setHtml( resultBuffer );

        fXMLFile.remove();
        return;
    }
    else
    {

        sHTML = "<HTML><body><H2>No news URL selected for " + sSelectedEvent + "</H2></body></HTML>";
        palette = ui->webView_OnlineTable->palette();
        palette.setBrush(QPalette::Base, Qt::transparent);
        ui->webView_URL->page()->setPalette(palette);
        ui->webView_URL->setAttribute(Qt::WA_OpaquePaintEvent, false);
        ui->webView_URL->setAttribute(Qt::WA_TranslucentBackground, true);
        ui->webView_URL->setHtml(sHTML, QUrl::fromLocalFile(QDir::currentPath()));
    }
}

bool MainWindow::existDatabase()
{

    QFile fDbFile;
    QString path;
    bool existDb;

#ifdef Q_OS_LINUX
        // NOTE: We have to store database file into user home folder in Linux
//            QString path(QDir::home().path());
        path = QDir::home().path();
        path.append(QDir::separator()).append(".qsportsevent").append(QDir::separator()).append("qsportsevent.db");
        path = QDir::toNativeSeparators(path);
#else
        path = "./qsportsevent.db" ;
        // NOTE: File exists in the application private folder, in Symbian Qt implementation
#endif
        fDbFile.setFileName(path);
//        qDebug() << "Db path:" << path;
//        qDebug() << "fDbFile.exists():" << fDbFile.exists();
        existDb = fDbFile.exists();

        if (existDb)
        {
            fDbFile.setPermissions(QFile::ReadOwner | QFile::WriteOwner | QFile::ReadUser |QFile::WriteUser);
            db = QSqlDatabase::addDatabase("QSQLITE");
            db.setDatabaseName(path);
            if (!db.open())
            {
                qDebug() << "Failed to connect";
                qDebug() << db.lastError();
            }
        }

        return existDb ;
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::loadMenu()
{
    QMenuBar *menuBar=new QMenuBar();
//    QAction *showImportEvents=new QAction("Import Event",this);
//    menuBar->addAction(showImportEvents);
//    connect(showImportEvents,SIGNAL(triggered()),this,SLOT(showImportEvents()));
    QAction *showAbout=new QAction("About",this);
    menuBar->addAction(showAbout);
    connect(showAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
    setMenuBar(menuBar);
}

void MainWindow::showImportEvents()
{

    dlgImportEvents = new importevents;

    dlgImportEvents->show();
    if (dlgImportEvents->exec() == QDialog::Accepted)
    {
    }
    populateSportCombo();
}


void MainWindow::displayGames()
{
    QSqlQuery qry;
    QString sql;
    QString sqlAppend1;
    QString sqlAppend2;
    QString str;
    int iTeamID;
    int iSelectedTeamID;

    sql = "SELECT rowid, name from teams "
          "WHERE grouprowid=:grouprowid ";

    qry.prepare(sql);
    qry.bindValue(":grouprowid", iEventID);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
    qDebug() << sSelectedTeam;
    hTeams.clear();

    hStanding.clear();
//    qDebug() << s.keys();
//    qDebug() << s.values();

    while (qry.next()) {
        Standing stTeam;
        hTeams[qry.value(1).toString()] = qry.value(0).toInt();
        iTeamID = qry.value(0).toInt();
        stTeam.sTeamName = qry.value(1).toString();
        if (stTeam.sTeamName.compare(sSelectedTeam) == 0)
        {
            iSelectedTeamID = iTeamID;
            qDebug() << iSelectedTeamID;
        }
        stTeam.iPoints = 0;
        stTeam.iWins = 0;
        stTeam.iDraws = 0;
        stTeam.iLosses = 0;
        stTeam.iScored = 0;
        stTeam.iConceeded = 0;
        stTeam.iTeamRowID = qry.value(0).toInt();
        hStanding[qry.value(0).toInt()] = stTeam;
    }

    sqlAppend1="";
    sqlAppend2="";
    sql ="SELECT hometeamrowid, awayteamrowid, homegoals, awaygoals, grouprowid, gametime, round from games ";
    if (sSelectedGroup != "All")
    {
        sqlAppend1 = " grouprowid=" + QString::number(iEventID,10);
    }
qDebug() << sSelectedRound;
    if (sSelectedRound != "All")
    {
        sqlAppend2 = " round='" + sSelectedRound + "'";
    }

    if (sqlAppend1 != "" && sqlAppend2 != "")
    {
        sql = sql + " WHERE " + sqlAppend1 + " AND " + sqlAppend2;
    }
    else if (sqlAppend1 != "")
    {
        sql = sql + " WHERE " + sqlAppend1 ;
    }
    else if (sqlAppend2 != "")
    {
        sql = sql + " WHERE " + sqlAppend2;
    }

    if (sSelectedTeam != "" && sSelectedTeam != "All")
    {
        sql = sql + " AND (hometeamrowid = " + QString::number(iSelectedTeamID) + " OR awayteamrowid = " + QString::number(iSelectedTeamID) + ")";
    }

    qry.prepare(sql);

    qDebug() << sql;

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    ui->twGames->clear();

    ui->twGames->setColumnCount(4);

    int row=0;
    while (qry.next()) {
        ui->twGames->setRowCount(row+1);

        for (int column = 0; column < 6; column++)
        {
            switch (column)
            {
//             0:     //grouprowid
//                str = hGroups.key(qry.value(column).toInt());
                break;
            case 0:     //hometeamrowid
            case 1:     //awayteamrowid
                str = hTeams.key(qry.value(column).toInt());
                break;
//            case 1:     //gametime
            case 2:     //hometeamgoal
            case 3:     //awayteamgoal
                if (qry.value(column).toInt() == -1)    //No data provided, i.e., game has not yet been played
                {
                    str = "";
                }
                else
                {
                    str = qry.value(column).toString();
                }
                break;
            default:
                break;
            }
            QTableWidgetItem *newItem = new QTableWidgetItem(str);
            newItem->setFlags(Qt::ItemIsEnabled);
            ui->twGames->setItem(row, column, newItem);
        }
        row++;
     }
    ui->twGames->resizeColumnsToContents();
/*
    // Will be needed when predictions are reintroduced.
    ui->twGames->setItemDelegateForColumn(4, new SpinBoxDelegate(ui->twGames));
    ui->twGames->setItemDelegateForColumn(5, new SpinBoxDelegate(ui->twGames));
    ui->twGames->setColumnWidth(4,40);
    ui->twGames->setColumnWidth(5,40);
*/
//    ui->twGames->sortByColumn(2,Qt::AscendingOrder);

}

void MainWindow::populateGroupCombo()
{
    QSqlQuery qry;

    qry.prepare("SELECT rowid, name "
                 "FROM teamgroups "
                 "WHERE eventrowid=:eventrowid");

    qry.bindValue(":eventrowid", iEventID);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    ui->cbGroups->clear();
    ui->cbGroups->addItem("All");
    while (qry.isValid())
    {
        ui->cbGroups->addItem(qry.value(1).toString());
        qry.next();
    }
}

void MainWindow::populateSelect()
{
    QSqlQuery qry;
    int iItemSportType = 2000;
    QString sSport;

    qry.prepare("SELECT DISTINCT sport "
                "FROM events "
                "ORDER BY sport ASC");

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    ui->twSelect->clear();
    ui->twSelect->setColumnCount(1);
    QList<QTreeWidgetItem *> lSports;
    while (qry.isValid())
    {
        sSport = qry.value(0).toString();
        QTreeWidgetItem *qtwiSports = new QTreeWidgetItem((QTreeWidget*)0, QStringList(sSport),iItemSportType);
        qtwiSports->addChildren(getRegions(qry.value(0).toString()));
        lSports.append(qtwiSports);
        hSportType[sSport] = iItemSportType;
        qDebug() << sSport;
        qDebug() << iItemSportType;
//        if (sSport == "Football")
//        {
//            ui->twSelect->topLevelItem(0)->setText(0,"");
//            ui->twSelect->topLevelItem(0)->setIcon(0, QIcon(":/images/icons/resource/sports/soccer_64.png"));
            qtwiSports->setText(0,"");
            qtwiSports->setIcon(0, QIcon(":/images/icons/resource/sports/" + sSport + ".png"));
//        }
//        else
//        {
//            ui->twSelect->topLevelItem(0)->setText(0,sSport);
//            qtwiSports->setText(0,sSport);
 //       }
        qry.next();
        iItemSportType++;
    }
    ui->twSelect->insertTopLevelItems(0, lSports);
//    ui->twSelect->topLevelItem(0)->setExpanded(true);
    isLeagueListPopulated = true;

}

void MainWindow::populateSportCombo()
{
    populateSelect();
}

QList<QTreeWidgetItem *> MainWindow::getRegions(QString sSport)
{
    QList<QTreeWidgetItem *> lRegions;
    QSqlQuery qry;

    qry.prepare("SELECT DISTINCT region "
                 "FROM events "
                 "WHERE sport=:sport "
                 "ORDER BY region ASC");
    qry.bindValue(":sport", sSport);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    while (qry.isValid())
    {

        QTreeWidgetItem *qtwiRegions = new QTreeWidgetItem((QTreeWidget*)0, QStringList(qry.value(0).toString()),typeRegion);
        qtwiRegions->addChildren(getEvents(sSport, qry.value(0).toString()));
        lRegions.append(qtwiRegions);

        qry.next();
    }
    return lRegions;
}

QList<QTreeWidgetItem *> MainWindow::getEvents(QString sSport, QString sRegion)
{
    QList<QTreeWidgetItem *> lEvents;
    QSqlQuery qry;

//    bool bFirst = true;
    qry.prepare("SELECT DISTINCT name "
                 "FROM events "
                 "WHERE sport=:sport and region=:region "
                 "ORDER BY name ASC");
    qry.bindValue(":sport", sSport);
    qry.bindValue(":region", sRegion);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    while (qry.isValid())
    {

        QTreeWidgetItem *qtwiEvents = new QTreeWidgetItem((QTreeWidget*)0, QStringList(qry.value(0).toString()),typeEvent);
//        qtwiEvents->addChildren(getSeasons(sSport, sRegion, qry.value(0).toString()));
        lEvents.append(qtwiEvents);

        qry.next();
    }
    return lEvents;
}

QList<QTreeWidgetItem *> MainWindow::getSeasons(QString sSport, QString sRegion, QString sEventName)
{
    QList<QTreeWidgetItem *> lSeasons;
    QSqlQuery qry;
//    QTreeWidgetItem qtwiSeason;

    qry.prepare("SELECT DISTINCT season "
                 "FROM events "
                 "WHERE sport=:sport and region=:region and name=:name "
                 "ORDER BY season DESC");
    qry.bindValue(":sport", sSport);
    qry.bindValue(":region", sRegion);
    qry.bindValue(":name", sEventName);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    while (qry.isValid())
    {
        QTreeWidgetItem *qtwiSeason = new QTreeWidgetItem((QTreeWidget*)0, QStringList(qry.value(0).toString()),typeSeason);
        lSeasons.append(qtwiSeason);
        qry.next();
    }
    return lSeasons;
}

void MainWindow::populateRegionCombo(QString sSport)
{
}

void MainWindow::populateTeamCombo()
{
    QSqlQuery qry;
    QString sql;
    QString sqlAppend;

    sql = "SELECT rowid, name "
          "FROM teams "
          "WHERE grouprowid=:grouprowid "
          "ORDER BY name ASC ";

    qry.prepare(sql);
    //Hardcoded grouprowid to 1
    qry.bindValue("grouprowid",iEventID);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    ui->cbTeam->clear();
    ui->cbTeam->addItem("All");
    while (qry.isValid())
    {
        ui->cbTeam->addItem(qry.value(1).toString());
        qry.next();
    }
}

void MainWindow::populateRoundCombo(int iSelectedEventID)
{
    QSqlQuery qry;
    int iMaxRound;

    qry.prepare("SELECT MAX(round) "
                 "FROM games "
                 "WHERE grouprowid=:grouprowid ");

    qry.bindValue("grouprowid",iSelectedEventID);
    qDebug() << iSelectedEventID;
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();
    iMaxRound = qry.value(0).toInt();
    ui->cbRounds->clear();
//    ui->cbRounds->addItem("All");

    for (int i=1; i<=iMaxRound; i++)
    {
        ui->cbRounds->addItem(QString::number(i,10));
    }
    ui->cbRounds->setCurrentIndex(getMaxPlayedRound(iSelectedEventID)-1);
}

void MainWindow::populateSeasonCombo(QString sSport, QString sRegion, QString sEventName)
{
    QSqlQuery qry;

    qry.prepare("SELECT DISTINCT season "
                 "FROM events "
                 "WHERE sport=:sport and region=:region and name=:name "
                 "ORDER BY season DESC");
    qry.bindValue(":sport", sSport);
    qry.bindValue(":region", sRegion);
    qry.bindValue(":name", sEventName);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();
    ui->cbSeason->clear();

    while (qry.isValid())
    {
        ui->cbSeason->addItem(qry.value(0).toString());
        qry.next();
    }

}

int MainWindow::getMaxPlayedRound(int iSelectedEventID)
{

    QSqlQuery qry;
    int iMaxRound = 1;

    qry.prepare("SELECT MAX(round) "
                 "FROM games "
                 "WHERE homegoals<>-1 AND awaygoals<>-1 "
                 "AND grouprowid=" + QString::number(iSelectedEventID));
    qDebug() << iSelectedEventID;
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();
    qDebug() << qry.lastQuery();

    if (qry.isValid())
    {
        iMaxRound = qry.value(0).toInt();
        qDebug() << iMaxRound;
    }
    sSelectedRound = QString::number(iMaxRound);
    return iMaxRound;
}

void MainWindow::populateEventCombo(QString sSport, QString sRegion)
{
}

int MainWindow::populateFavourites()
{
    QSqlQuery qry;
    QString sql;
    int i, j;
    int iRowCount;
    bool isCheckedFound = false;
    i=0;

    sql ="SELECT showdefault, sport, region, name, url from favourites "
         "ORDER BY sport, region, name ";

    qry.prepare(sql);
//    qDebug() << sql;

    if (!qry.exec())
    {
//        qDebug() << qry.lastQuery();
//        qDebug() << qry.lastError();
    }

    iRowCount = ui->twFavourites->rowCount();
    for (j = 0; j<=iRowCount-1; j++)
    {
        ui->twFavourites->removeRow(0);
    }
    while (qry.next()) {
        ui->twFavourites->setRowCount(ui->twFavourites->rowCount()+1);
        QTableWidgetItem *newItem;

        qDebug() << hSportType.value(qry.value(1).toString());
//        if (qry.value(1).toString() == "Football")
//        {
            newItem = new QTableWidgetItem(hSportType.value(qry.value(1).toString()));//add
            qDebug() << hSportType.value(qry.value(1).toString());
//            newItem->setIcon(QIcon(":/images/icons/resource/sports/soccer_64.png")); //Add Icon
            newItem->setIcon(QIcon(":/images/icons/resource/sports/" + qry.value(1).toString() + ".png")); //Add Icon
            ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 1, newItem);
//        }
//        else
//        {
//            newItem = new QTableWidgetItem(qry.value(1).toString(),hSportType.value(qry.value(1).toString())); //Sport
//            newItem->setFlags(Qt::NoItemFlags);
//            ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 1, newItem);
//        }
        newItem = new QTableWidgetItem(qry.value(2).toString()); //Region
        newItem->setFlags(Qt::NoItemFlags);
        ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 2, newItem);
        newItem = new QTableWidgetItem(qry.value(3).toString()); //Name
        newItem->setFlags(Qt::NoItemFlags);
        ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 3, newItem);
        newItem = new QTableWidgetItem(qry.value(4).toString()); //URL
        ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 4, newItem);

        newItem = new QTableWidgetItem(0); //ShowDefault
        if (qry.value(0).toInt() == 0)
        {
            newItem->setCheckState(Qt::Unchecked);
        }
        else
        {
            newItem->setCheckState(Qt::Checked);
            if (!isCheckedFound)
            {
                // Display the first selected 'default' league.
                isCheckedFound = true;
                sSelectedSport = qry.value(1).toString();
                sSelectedRegion = qry.value(2).toString();
                sSelectedEvent =  qry.value(3).toString();
                sSelectedSeason = getCurrentSeason(sSelectedSport, sSelectedRegion, sSelectedEvent);

                populateSeasonCombo(sSelectedSport, sSelectedRegion, sSelectedEvent);
                sSelectedURL = qry.value(4).toString();
                this->setWindowTitle("MobiTifo - " + sSelectedEvent);

            }
        }

        newItem->setFlags(Qt::ItemIsUserCheckable | Qt::ItemIsEnabled | Qt::ItemIsEditable | Qt::ItemIsSelectable);
        ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 0, newItem);

        i++;
    }

    if (!isCheckedFound)
    {
        // If a default league was found, show the league tab instead of the favourites tab.
        ui->tabWidget->setCurrentWidget(ui->tab_Favourites);
    }

    isFavouritesListPopulated = true;
    return i;
}

void MainWindow::on_tabWidget_currentChanged ( int index )
{

    if (!isLeagueListPopulated)
    {
        populateSelect();
    }

    if (ui->tabWidget->currentWidget() == ui->tab_OfflineMatches)
    {
        //Display downloaded games
        iEventID = dlgImportEvents->getEventID(sSelectedEvent,
                                               sSelectedSport,
                                               sSelectedSeason,
                                               sSelectedRegion);
        qDebug() << iEventID;
        qDebug() << sSelectedEvent;
        qDebug() << sSelectedSport;
        qDebug() << sSelectedSeason;
        qDebug() << sSelectedRegion;
        populateRoundCombo(iEventID);
        sSelectedTeam="All";
        ui->cbGroups->setVisible(false);
        populateTeamCombo();
        displayGames();
    }
    else if (ui->tabWidget->currentWidget() == ui->tab_OfflineTable)
    {
        int iMaxRound = 1;
        //Display table standings games
        iEventID = dlgImportEvents->getEventID(sSelectedEvent,
                                               sSelectedSport,
                                               sSelectedSeason,
                                               sSelectedRegion);
        qDebug() << sSelectedEvent;
        qDebug() << sSelectedSport;
        qDebug() << sSelectedSeason;
        qDebug() << sSelectedRegion;
        displayGames(); // showStandings depends on data from displayGames, so we have to call that first!
        //Set values for the From/To sliders.
        iMaxRound = getMaxPlayedRound(iEventID);

        ui->vsFromRound->setValue(1);
        ui->vsToRound->setValue(iMaxRound);
        ui->vsFromRound->setMinimum(1);
        ui->vsFromRound->setMaximum(iMaxRound);
        ui->vsToRound->setMinimum(1);
        ui->vsToRound->setMaximum(iMaxRound);
        ui->vsFromRound->setTickPosition(QSlider::TicksBothSides);
        ui->vsToRound->setTickPosition(QSlider::TicksBothSides);
        ui->vsFromRound->setTickInterval(5);
        ui->vsToRound->setTickInterval(5);
        ui->vsFromRound->setSingleStep(1);
        ui->vsToRound->setSingleStep(1);
        ui->vsFromRound->setPageStep(5);
        ui->vsToRound->setPageStep(5);

        showStandings();
    }
    else if (ui->tabWidget->currentWidget() == ui->tab_UpdateScores)
    {
        ui->webView_UpdateScores->setUrl(QUrl("http://www.aragon.ws/soccerdb/"));
        ui->webView_UpdateScores->show();
        //Show Update Scores Page
    }
    else if (ui->tabWidget->currentWidget() == ui->tab_OnlineTable)
    {
        //Show Online Table Page
        showOnlineTable();
    }
    else if (ui->tabWidget->currentWidget() == ui->tab_News)
    {
        //Show News Page
        showURL();
    }
    else if (ui->tabWidget->currentWidget() == ui->tab_LiveScore)
    {
        //Show Live Scores
        showLiveScores();
//        ui->tabWidget->setCurrentWidget(ui->tab_LiveScore);
    }
    else if (ui->tabWidget->currentWidget() == ui->tab_Chat)
    {
        if (!isChatLoaded)
        {
            QWebFrame *wfMain;
            QPalette palette;

            palette = ui->webView_Chat->palette();
            palette.setBrush(QPalette::Base, Qt::transparent);
            ui->webView_Chat->page()->setPalette(palette);
            //Show Chat page
            //        ui->webView_Chat->setUrl(QUrl("http://mobitifo.chatango.com"));
            ui->webView_Chat->setUrl(QUrl("http://www.mobitifo.com/home/chat"));
//            ui->webView_Chat->setUrl(QUrl("http://www.mobitifo.com/home/fifa-world-leagues-widget"));
            ui->webView_Chat->show();
            wfMain = ui->webView_Chat->page()->mainFrame();
            wfMain->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOn);
            wfMain->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOn);
            isChatLoaded = true;
        }
    }
    else if (ui->tabWidget->currentWidget() == ui->tab_Predict)
    {
        if (!isPredictLoaded)
        {
            QWebFrame *wfMain;
            QPalette palette;

            palette = ui->webView_Predict->palette();
            palette.setBrush(QPalette::Base, Qt::transparent);
            ui->webView_Predict->page()->setPalette(palette);
            //Show Prediction page
            ui->webView_Predict->setUrl(QUrl("http://www.predictfootballscore.com/predictions.php?p_league_id=55"));
            ui->webView_Predict->show();
            wfMain = ui->webView_Predict->page()->mainFrame();
            wfMain->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOn);
            wfMain->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOn);
            isPredictLoaded = true;
        }
    }
}

void MainWindow::on_twSelect_itemExpanded (QTreeWidgetItem *item)
{
    //Check if it is the season item that has been selected
    qDebug() << "itemExpanded";

    if (item->type() == typeEvent)
    {
        qDebug() << "itemExpanded:typeEvent";
        //Check if the icons/buttons have already been added to the widget
        if (item->columnCount()!=1)
        {
//            item->
        }
    }
}

QString MainWindow::getCurrentSeason(QString sSport,
                                     QString sRegion,
                                     QString sEvent)
{
    QSqlQuery qry;
    QString sql;

    sql = "SELECT season, soccerdbid from events "
          "WHERE name=:name and region=:region and sport=:sport "
          "ORDER BY season DESC";
    qry.prepare(sql);
    qry.bindValue(":name", sEvent);
    qry.bindValue(":region", sRegion);
    qry.bindValue(":sport", sSport);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (qry.next()) {
        sSelectedSeason = qry.value(0).toString();
        iSelectedSoccerDBID = qry.value(1).toInt();
    }
    qDebug() << qry.lastQuery();
    qDebug() << sSelectedSeason;
    qDebug() << iSelectedSoccerDBID;

    return sSelectedSeason;
}

void MainWindow::on_twFavourites_clicked ( const QModelIndex & index )
{
    QTableWidgetItem *qtwiItem;
    int row, column;

    row = index.row();
    column = index.column();

    qtwiItem = ui->twFavourites->item(row,1);
    qDebug() << qtwiItem->type();
    sSelectedSport = hSportType.key(qtwiItem->type());
    qDebug() << sSelectedSport;
    qtwiItem = ui->twFavourites->item(row,2);
    sSelectedRegion = qtwiItem->text();
    qtwiItem = ui->twFavourites->item(row,3);
    sSelectedEvent = qtwiItem->text();
    qtwiItem = ui->twFavourites->item(row,4);
    sSelectedURL = qtwiItem->text();


    populateSeasonCombo(sSelectedSport, sSelectedRegion, sSelectedEvent);
    showSelectedEvent2();
    qDebug() << column;

    if (column != 4 && column != 0) // Don't update if Default or URL was clicked.
    {
//        showLiveScores();
//        ui->tabWidget->setCurrentWidget(ui->tab_LiveScore);
        if (sSelectedSport == "Football")
        {
            ui->tabWidget->setCurrentWidget(ui->tab_OfflineMatches);
        }
        else
        {
            ui->tabWidget->setCurrentWidget(ui->tab_News);
        }
    }
}

void MainWindow::on_twFavourites_cellChanged ( int row, int column )
{
    QSqlQuery qry;
    QString sql;
    QString sURL;
    int iDefault;
    QTableWidgetItem *qtwiItem;

    if ((column == 4 || column == 0) && isFavouritesListPopulated) //Default or URL
    {
        qtwiItem = ui->twFavourites->item(row,0);
        iDefault = qtwiItem->checkState();
        qtwiItem = ui->twFavourites->item(row,1);
        sSelectedSport = hSportType.key(qtwiItem->type());
        qtwiItem = ui->twFavourites->item(row,2);
        sSelectedRegion = qtwiItem->text();
        qtwiItem = ui->twFavourites->item(row,3);
        sSelectedEvent = qtwiItem->text();
        qtwiItem = ui->twFavourites->item(row,4);
        sURL = qtwiItem->text();
        sSelectedURL = sURL;

        qry.prepare("UPDATE favourites SET showdefault=:showdefault, url=:url "
                    "WHERE name=:name and region=:region and sport=:sport ");

        qry.bindValue(":name", sSelectedEvent);
        qry.bindValue(":region", sSelectedRegion);
        qry.bindValue(":sport", sSelectedSport);
        qry.bindValue(":showdefault", iDefault);
        qry.bindValue(":url", sURL);

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }

        if (column == 4)
        {
            //Display News tab
            ui->tabWidget->setCurrentWidget(ui->tab_News);
        }
    }
}

void MainWindow::on_pbZoomIn_clicked()
{
    QWebFrame *wfMain;

    wfMain = ui->webView_LiveScore->page()->mainFrame();
    ui->webView_LiveScore->setZoomFactor(1.4);
    wfMain->setScrollBarValue(Qt::Horizontal, 370);
    wfMain->setScrollBarValue(Qt::Vertical, 400);

}

void MainWindow::on_pbZoomOut_clicked()
{
    QWebFrame *wfMain;

    wfMain = ui->webView_LiveScore->page()->mainFrame();
    ui->webView_LiveScore->setZoomFactor(1);
    wfMain->setScrollBarValue(Qt::Horizontal, 1);
    wfMain->setScrollBarValue(Qt::Vertical, 1);
}

void MainWindow::on_pbZoomInURL_clicked()
{
    ui->webView_URL->setZoomFactor(ui->webView_URL->zoomFactor()+0.2);
    ui->webView_URL->show();
}

void MainWindow::on_pbZoomOutURL_clicked()
{
    ui->webView_URL->setZoomFactor(ui->webView_URL->zoomFactor()-0.2);
    ui->webView_URL->show();
}

void MainWindow::on_pbBack_clicked()
{
    ui->webView_URL->page()->triggerAction(QWebPage::Back);
}

void MainWindow::on_pbBackLiveScore_clicked()
{
    ui->webView_LiveScore->page()->triggerAction(QWebPage::Back);
}

void MainWindow::on_pbUpdateScoreBack_clicked()
{
    ui->webView_UpdateScores->page()->triggerAction(QWebPage::Back);
}


void MainWindow::on_pbAddFavourite_clicked()
{

    QSqlQuery qry;
    QString sql;

    sql ="SELECT showdefault, sport, region, name, url from favourites "
         "WHERE sport=:sport and region=:region and name=:name";

    qry.prepare(sql);
//    qDebug() << sql;

    qry.bindValue(":sport", sSelectedSport);
//    qry.bindValue(":sport", "Football");
    qry.bindValue(":region", sSelectedRegion);
    qry.bindValue(":name", sSelectedEvent);


    if (!qry.exec())
    {
//        qDebug() << qry.lastQuery();
//        qDebug() << qry.lastError();
    }
    else
    {
        if (qry.next())
        {
            return; // A record with the selected keys already exists.
        }
    }


    qry.prepare("INSERT INTO favourites (showdefault, sport, region, name, url) VALUES "
                "(:showdefault, :sport, :region, :name, :url)");

    qry.bindValue(":showdefault", 0);
    qry.bindValue(":sport", sSelectedSport);
    qry.bindValue(":region", sSelectedRegion);
    qry.bindValue(":name", sSelectedEvent);
    qry.bindValue(":url", "");

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
        qDebug() << qry.executedQuery();
        qDebug() << qry.boundValues();
    }
    else
    {
        isFavouritesListPopulated = false;
        populateFavourites();
    }

}

void MainWindow::on_pbRemoveFavourite_clicked()
{

    QSqlQuery qry;
    QTableWidgetItem *qtwiItem ;

    QString sql;
    int row;

    row =  ui->twFavourites->selectedItems().first()->row();

    qtwiItem = ui->twFavourites->item(row,1);
    sSelectedSport = hSportType.key(qtwiItem->type());

    //    qDebug() << sSelectedSport;
    qtwiItem = ui->twFavourites->item(row,2);
    sSelectedRegion = qtwiItem->text();
//    qDebug() << sSelectedRegion;
    qtwiItem = ui->twFavourites->item(row,3);
    sSelectedEvent = qtwiItem->text();
//    qDebug() << sSelectedEvent;

    qry.prepare("DELETE FROM favourites "
                "WHERE name=:name and region=:region and sport=:sport ");

    qry.bindValue(":sport", sSelectedSport);
    qry.bindValue(":region", sSelectedRegion);
    qry.bindValue(":name", sSelectedEvent);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
        qDebug() << qry.executedQuery();
        qDebug() << qry.boundValues();
    }
    else
    {
//        qDebug() << "Delete Event:" << sSelectedEvent;
        ui->twFavourites->removeRow(row);
    }

}


void MainWindow::on_cbTeam_activated(QString sTeamName)
{
    sSelectedTeam = sTeamName;
    sSelectedRound = "All";
    displayGames();
}

void MainWindow::on_cbGroups_activated(QString sGroupName)
{
    sSelectedGroup = sGroupName;
    sSelectedTeam = "All";
    displayGames();
    showStandings();
}

void MainWindow::on_cbSeason_activated(QString sSeason)
{
    QSqlQuery qry;
    QString sql;

    sSelectedSeason = sSeason;
    sql = "SELECT rowid, soccerdbid from events "
          "WHERE name = :name and season = :season and region = :region";
    qry.prepare(sql);
    qry.bindValue(":name", sSelectedEvent);
    qry.bindValue(":season", sSelectedSeason);
    qry.bindValue(":region", sSelectedRegion);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (qry.next()) {
        iEventID = qry.value(0).toInt();
        iSelectedSoccerDBID = qry.value(1).toInt();
    }
    else
    {
        iEventID = -1;
    }

    populateRoundCombo(iEventID);
    sSelectedTeam="All";
    ui->cbGroups->setVisible(false);
    populateTeamCombo();
    displayGames();
}


void MainWindow::populateSeason(QString sSeason)
{
    QSqlQuery qry;
    QString sql;

    sSelectedSeason = sSeason;
    sql = "SELECT rowid, soccerdbid from events "
          "WHERE name = :name and season = :season and region = :region";
    qry.prepare(sql);
    qry.bindValue(":name", sSelectedEvent);
    qry.bindValue(":season", sSelectedSeason);
    qry.bindValue(":region", sSelectedRegion);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (qry.next()) {
        iEventID = qry.value(0).toInt();
        iSelectedSoccerDBID = qry.value(1).toInt();
    }
    else
    {
        iEventID = -1;
    }

    showOnlineLeague(iSelectedSoccerDBID);

}

void MainWindow::on_cbRounds_activated(QString sRound)
{
    sSelectedRound = sRound;
    sSelectedTeam = "All";

    ui->cbRounds->show();
/*
    QPropertyAnimation animation(ui->twGames, "geometry");
    animation.setDuration(5000);
    animation.setKeyValueAt(0,QRect(0, 0, 651, 311));
    animation.setKeyValueAt(0.5,QRect(651, 0, 651, 311));
    animation.setKeyValueAt(1,QRect(0, 0, 651, 311));
    QPropertyAnimation animation(ui->cbRounds, "geometry");
    animation.setDuration(5000);
    animation.setKeyValueAt(0,QRect(650, 37, 151, 31));
    animation.setKeyValueAt(0.5,QRect(900, 37, 151, 31));
    animation.setKeyValueAt(1,QRect(650, 37, 151, 31));
    animation.start();
*/
    displayGames();

//    QPushButton button("Animated Button");
//    button.show();
//    QPropertyAnimation animation(&button, "geometry");
}

void MainWindow::showAbout()
{
    QString message = "";
    QString version;

//    message.append(APP_NAME);
    message.append("MobiTifo");
    message.append("-");
//    version = version.setNum(APP_VERSION);
    version = "0.0.8";
    message.append(version);
    message.append("\n by ");
//    message.append(AUTHOR);
    message.append("Magnus Lundgren (qsportsevent@gmail.com)\n");
    message.append("MobiTifo is on Twitter (twitter.com/QSportsEvent).\n");
    message.append("Visit wiki.maemo.org/QSportsEvent for latest news.\n");
    message.append("With special thanks to the maemo.org community for its input.\n");
    message.append("Special mention to Reflektorfalke, robbie, fgs, Haus3r, pantera1989, ....\n");
    message.append("Data is provided by http://www.aragon.ws/soccerdb/.\n");
    message.append("Please visit that site and donate to its author.\n");
    message.append("Live data is provided by http://www.livescore.in/.\n");
    message.append("Future versions of MobiTifo might use other data sources.\n");
    QMessageBox::about ( this, tr("About"), message);
}

void MainWindow::showStandings()
{
    QSqlQuery qry;
    QString sql;
    int iHomeTeamID;
    int iAwayTeamID;
    int iHomeGoals;
    int iAwayGoals;

    Standing stHomeTeam;
    Standing stAwayTeam;
    QTableWidgetItem *newItem;

    QMutableHashIterator<int, Standing> iter(hStanding);

    Standing stTeam;
    while (iter.hasNext())
    {
        iter.next();
        iter.value().iPoints = 0;
        iter.value().iWins = 0;
        iter.value().iDraws = 0;
        iter.value().iLosses = 0;
        iter.value().iScored = 0;
        iter.value().iConceeded = 0;
    }

    int iFrom, iTo;
    iFrom = ui->txtFrom->text().toInt();
    iTo = ui->txtTo->text().toInt();
    if (iFrom == 0)
    {
        iFrom = 1;
    }

    if (iTo == 0)
    {
        iTo = 1;
    }

    sql ="SELECT hometeamrowid, awayteamrowid, homegoals, awaygoals from games "
         " WHERE homegoals<>-1 and awaygoals<>-1 "
         " AND grouprowid=" + QString::number(iEventID) +
         " AND round>=" + QString::number(iFrom) +
         " AND round<=" + QString::number(iTo);

    qry.prepare(sql);
//    qDebug() << sql;

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
    while (qry.next())
    {
        iHomeTeamID = qry.value(0).toInt();
        iAwayTeamID = qry.value(1).toInt();
        iHomeGoals = qry.value(2).toInt();
        iAwayGoals = qry.value(3).toInt();
        if (iAwayGoals != -1 && iHomeGoals != -1)
        {
            stHomeTeam = hStanding.value(iHomeTeamID);
            stAwayTeam = hStanding.value(iAwayTeamID);
            if (iHomeGoals > iAwayGoals)
            {
                stHomeTeam.iPoints=stHomeTeam.iPoints + 3;
                stHomeTeam.iWins++;
                stAwayTeam.iLosses++;
            }
            else if (iHomeGoals < iAwayGoals)
            {
                stAwayTeam.iPoints=stAwayTeam.iPoints + 3;
                stHomeTeam.iLosses++;
                stAwayTeam.iWins++;
            }
            else
            {
                stHomeTeam.iPoints=stHomeTeam.iPoints + 1;
                stAwayTeam.iPoints=stAwayTeam.iPoints + 1;
                stHomeTeam.iDraws++;
                stAwayTeam.iDraws++;
            }

            stHomeTeam.iScored=stHomeTeam.iScored + iHomeGoals;
            stHomeTeam.iConceeded=stHomeTeam.iConceeded + iAwayGoals;
            stAwayTeam.iScored=stAwayTeam.iScored + iAwayGoals;
            stAwayTeam.iConceeded=stAwayTeam.iConceeded + iHomeGoals;

            hStanding[iHomeTeamID] = stHomeTeam;
            hStanding[iAwayTeamID] = stAwayTeam;
        }
    }

    int j=0;
    QHash<int, Standing>::iterator i;

    while (ui->twStandings->rowCount()>0)
    {
        ui->twStandings->removeRow(0);
    }
    ui->twStandings->setRowCount(hStanding.count());
    ui->twStandings->setColumnCount(9);


    for (i = hStanding.begin(); i != hStanding.end(); ++i)
    {
        stAwayTeam = i.value();

        //Team Name
        newItem = new QTableWidgetItem(stAwayTeam.sTeamName);
        newItem->setFlags(Qt::ItemIsEnabled);
        ui->twStandings->setItem(j, 0, newItem);

        //Games played
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iWins +
                                                       stAwayTeam.iDraws +
                                                       stAwayTeam.iLosses,10));
        newItem->setFlags(Qt::ItemIsEnabled);
        newItem->setTextAlignment(Qt::AlignRight);
//        qDebug() << j << QString::number(stAwayTeam.iPoints,10);
        ui->twStandings->setItem(j, 1, newItem);

        //Games won
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iWins,10));
        newItem->setFlags(Qt::ItemIsEnabled);
        newItem->setTextAlignment(Qt::AlignRight);
//        qDebug() << j << QString::number(stAwayTeam.iWins,10);
        ui->twStandings->setItem(j, 2, newItem);

        //Games drawn
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iDraws,10));
        newItem->setFlags(Qt::ItemIsEnabled);
        newItem->setTextAlignment(Qt::AlignRight);
//        qDebug() << j << QString::number(stAwayTeam.iDraws,10);
        ui->twStandings->setItem(j, 3, newItem);

        //Games lost
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iLosses,10));
        newItem->setFlags(Qt::ItemIsEnabled);
        newItem->setTextAlignment(Qt::AlignRight);
//        qDebug() << j << QString::number(stAwayTeam.iLosses,10);
        ui->twStandings->setItem(j, 4, newItem);

        //Goals for
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iScored,10));
        newItem->setFlags(Qt::ItemIsEnabled);
        newItem->setTextAlignment(Qt::AlignRight);
//        qDebug() << j << QString::number(stAwayTeam.iScored,10);
        ui->twStandings->setItem(j, 5, newItem);

        //Goals against
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iConceeded,10));
        newItem->setFlags(Qt::ItemIsEnabled);
        newItem->setTextAlignment(Qt::AlignRight);
//        qDebug() << j << QString::number(stAwayTeam.iConceeded,10);
        ui->twStandings->setItem(j, 6, newItem);

        //Goal difference
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iScored-stAwayTeam.iConceeded,10));
        newItem->setFlags(Qt::ItemIsEnabled);
        newItem->setTextAlignment(Qt::AlignRight);
//        qDebug() << j << QString::number(stAwayTeam.iScored-stAwayTeam.iConceeded,10);
        ui->twStandings->setItem(j, 7, newItem);

        //Points
        newItem = new NumericTableWidgetItem();
        newItem->setFlags(Qt::ItemIsEnabled);
        newItem->setText(QString::number(stAwayTeam.iPoints,10));
        newItem->setTextAlignment(Qt::AlignRight);
        ui->twStandings->setItem(j, 8, newItem);

        j++;
    }
    ui->twStandings->resizeColumnsToContents();
    ui->twStandings->sortByColumn(8,Qt::DescendingOrder);

}

void MainWindow::on_pbMatchRating_clicked()
{
    qDebug() << ui->txtHomeTeam->text();
    showRooster(ui->txtHomeTeam->text(), ui->txtAwayTeam->text());
}

void MainWindow::showRooster(QString sHomeTeam, QString sAwayTeam)
{
//    teamrooster oTeamRooster;
//    window.show();


    teamrooster *window= new teamrooster(this, sHomeTeam, sAwayTeam);
    // this is the only Maemo specific line here
//    window->setWindowTitle("This is second window");
    #ifdef Q_WS_MAEMO_5
        window->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
        window->setAttribute(Qt::WA_DeleteOnClose);
//    window->setHomeTeam(sHomeTeam);
//    window->setAwayTeam(sAwayTeam);
    window->show();
 /*
    if (!window) {
       window = new QMainWindow(this, 0);
           window->setAttribute(Qt::WA_Maemo5StackedWindow);
//       connect(window, SIGNAL(destroyed(QObject*)),this, SLOT(windowDestroyed(QObject*)));
       window->show();
       qDebug() << "Window" << window;
   }
*/
}

/*
void MainWindow::windowDestroyed(QObject* obj)
{
    disconnect(obj, SIGNAL(destroyed(QObject*)),this, SLOT(windowDestroyed(QObject*)));
    qDebug() << "No window" << window;
}
*/

void MainWindow::removeEventGames(int iSelectedEventID)
{
    QSqlQuery qry;

    qry.prepare("DELETE FROM games "
                 "WHERE grouprowid=:iEventRowID ");

    qry.bindValue("grouprowid",iSelectedEventID);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }

}

void MainWindow::removeEventTeams(int iSelectedEventID)
{
    QSqlQuery qry;

    qry.prepare("DELETE FROM teams "
                 "WHERE grouprowid=:iEventRowID ");

    qry.bindValue("grouprowid",iSelectedEventID);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }


}

void MainWindow::on_pbDownloadStats_clicked()
{

    QSqlQuery qry;
    QString sNextGameDate, sLatestGameDate, sCurrentDate;
    int iEventRowID;
    ui->lblLoading->setVisible(true);

    sSelectedSeason = ui->cbSeason->currentText();
qDebug() << sSelectedSeason;
    qry.prepare("SELECT soccerdbid, rowid "
                 "FROM events "
                 "WHERE sport=:sport and region=:region and name=:name and season=:season "
                 "ORDER BY season DESC");
    qry.bindValue(":sport", sSelectedSport);
    qry.bindValue(":region", sSelectedRegion);
    qry.bindValue(":name", sSelectedEvent);
    qry.bindValue(":season", sSelectedSeason);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    if (qry.isValid())
    {
        iSelectedSoccerDBID = qry.value(0).toInt();
        iEventRowID = qry.value(1).toInt();
//        qry.next();
    }
    else
    {
        qDebug() << qry.lastQuery();
        qDebug() <<  sSelectedSport;
        qDebug() << sSelectedRegion;
        qDebug() << sSelectedEvent;
        qDebug() << sSelectedSeason;
    }

    iEventID = iEventRowID;
    qDebug() << iSelectedSoccerDBID;
/*
    iEventID = dlgImportEvents->getEventID(sSelectedEvent,
                                           sSelectedSport,
                                           sSelectedSeason,
                                           sSelectedRegion);
*/
    //Only download league dates if there might be new games that have been played
    sNextGameDate = getNextGameDate(iEventID);
    qDebug() << sNextGameDate;
    QDate dtCurrentDate;
    dtCurrentDate = QDate::currentDate();
    sCurrentDate.append(QString::number(dtCurrentDate.year()));
    sCurrentDate.append("-");
    sCurrentDate.append(QString::number(dtCurrentDate.month()));
    sCurrentDate.append("-");
    sCurrentDate.append(QString::number(dtCurrentDate.day()));

    qDebug() << sCurrentDate;
    sLatestGameDate = getLatestGameDate(iEventID);
    qDebug() << sLatestGameDate;
    if (sNextGameDate <= sCurrentDate)
    {
        removeEventGames(iEventRowID);
        removeEventTeams(iEventRowID);
        dlgImportEvents->LoadHeader(iSelectedSoccerDBID, iEventRowID, sLatestGameDate);
    }
    populateRoundCombo(iEventID);
    populateTeamCombo();
    displayGames();
    ui->lblLoading->setVisible(false);
}

QString MainWindow::getLatestGameDate(int iEventID)
{

    QString sLatestGameDate;
    QSqlQuery qry;


    qry.prepare("SELECT MAX(gametime) "
                "FROM games "
                "WHERE homegoals<>-1 AND awaygoals<>-1 "
                "AND grouprowid=" + QString::number(iEventID));
/*
    qry.prepare("SELECT gametime "
                "FROM games ");
*/
//                "WHERE homegoals<>-1 AND awaygoals<>-1 "
//                "AND grouprowid=" + QString::number(iEventID) + " ORDER BY gametime DESC LIMIT 1");

    qDebug() << iEventID;

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.next();

    if (qry.isValid())
    {
        sLatestGameDate = qry.value(0).toString();
        qDebug() << sLatestGameDate;
        if (sLatestGameDate == "")
        {
            sLatestGameDate = "1800-01-01";
        }
     }
    else
    {
        sLatestGameDate = "1800-01-01";
    }

    qDebug() << sLatestGameDate;

    return sLatestGameDate;
}

QString MainWindow::getNextGameDate(int iEventID)
{

    QString sNextGameDate;
    QSqlQuery qry;

    qry.prepare("SELECT MIN(gametime) "
                "FROM games "
                "WHERE homegoals=-1  "
                "AND grouprowid=" + QString::number(iEventID));


    /*
    qry.prepare("SELECT gametime "
                "FROM games ");
//                "WHERE homegoals<>-1 AND awaygoals<>-1 "
//                "AND grouprowid=" + QString::number(iEventID) + " ORDER BY gametime DESC LIMIT 1");
*/
    qDebug() << iEventID;

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.next();

    if (qry.isValid())
    {
        sNextGameDate = qry.value(0).toString();
        qDebug() << sNextGameDate;
        if (sNextGameDate == "")
        {
            sNextGameDate = "1800-01-01";
        }
     }
    else
    {
        sNextGameDate = "1800-01-01";
    }

    qDebug() << sNextGameDate;

    return sNextGameDate;
}
