#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "importevents.h"
#include "teamrooster.h"
#include <QTreeWidgetItem>
#include <QSqlDatabase>

namespace Ui {
    class MainWindow;
}

const int typeSport = 1;
const int typeRegion = 2;
const int typeEvent = 3;
const int typeSeason = 4;

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
    QSqlDatabase db;
    importevents *dlgImportEvents;
    void loadMenu();
    void displayGames();
    void populateGroupCombo();
    void populateRoundCombo();
    void populateEventCombo(QString sSport, QString sRegion);
    void populateTeamCombo();
    void populateSeasonCombo(QString sSport, QString sRegion, QString sEventName);
    void populateRegionCombo(QString sSport);
    void populateSportCombo();
    void populateSeason(QString sSeason);
    int populateFavourites();
    void showOnlineLeague(int sSelectedSoccerDBID);
    QList<QTreeWidgetItem *> getRegions(QString sSport);
    QList<QTreeWidgetItem *> getEvents(QString sSport, QString sRegion);
    QList<QTreeWidgetItem *> getSeasons(QString sSport, QString sRegion, QString sEventName);

    int iEventID;
    bool existDatabase();
    void showStandings();
    void showRooster(QString, QString);
    QPointer<QMainWindow> window;

public slots:
    void showImportEvents();
    void showAbout();
    void showSelectedEvent(QTreeWidgetItem*);

private slots:
    void on_cbGroups_activated(QString);
    void on_cbRounds_activated(QString);
//    void on_cbEvents_activated(QString);
//    void on_cbSport_activated(QString);
//    void on_cbRegion_activated(QString);
//    void on_cbSeason_activated(QString);
    void on_pbAddFavourite_clicked();
    void on_pbRemoveFavourite_clicked();
    void on_twFavourites_clicked ( const QModelIndex & index );
    void on_tabWidget_currentChanged ( int index );
    void on_twFavourites_cellChanged ( int row, int column );
    void on_pbMatchRating_clicked();
};

#endif // MAINWINDOW_H
