#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "importevents.h"
#include "spinboxdelegate.h"
#include "teamrooster.h"
#include <QSqlQuery>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlRecord>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QSqlQueryModel>
#include <QMenuBar>
#include <QMessageBox>
#include <QUrl>
#include <QWebFrame>
#include <QTreeWidgetItem>
#include <QPlastiqueStyle>

//QSqlDatabase db;
QString sSelectedGroup = "";
QString sSelectedRound = "All";
QString sSelectedSport  = "";
QString sSelectedRegion = "";
QString sSelectedEvent = "";
QString sSelectedSeason = "";
QString sSelectedURL = "";
int iSelectedSoccerDBID;
importevents *dlgImportEvents;
QHash<QString, int> hGroups;
QHash<QString, int> hTeams;
bool isLeagueListPopulated;
bool isFavouritesListPopulated;
//int iEventID;

struct Standing {
    int iTeamRowID;
    QString sTeamName;
    int iPoints;
    int iWins;
    int iDraws;
    int iLosses;
    int iScored;
    int iConceeded;
} stStanding;

//QList<Standing> listStanding;
QHash<int, Standing> hStanding;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    loadMenu();
//    QFile file("");
    isLeagueListPopulated = false;
    if (existDatabase())
    {
        ui->tab->setEnabled(false);
        ui->tab->hide();;
        ui->tab_2->setEnabled(false);
        ui->tab_2->hide();;
//        ui->tab_TeamRooster->hide();
//        ui->tab_TeamRooster->setEnabled(false);

        if (populateFavourites() == 0)
        {
            ui->tabWidget->setCurrentWidget(ui->tab_5);
        }
        else
        {
            ui->tabWidget->setCurrentWidget(ui->tab_Favourites);
        };
//        populateSportCombo();
//        populateEventCombo();
//        populateGroupCombo();
//        populateRoundCombo();
//        populateTeamCombo();
//        sSelectedRound = "All";
//        sSelectedGroup = "All";
//        displayGames();
//        showStandings();

        ui->webView_2->settings()->setAttribute(QWebSettings::JavascriptEnabled, true);
        ui->webView->settings()->setAttribute(QWebSettings::JavascriptEnabled, true);
        ui->webView->setStyle(new QPlastiqueStyle);
        ui->webView_2->setStyle(new QPlastiqueStyle);
        ui->twFavourites->setStyle(new QPlastiqueStyle);
        ui->twSelect->setStyle(new QPlastiqueStyle);
        ui->txtHomeTeam->setStyle(new QPlastiqueStyle);
        ui->txtAwayTeam->setStyle(new QPlastiqueStyle);
        ui->webView->setProperty("FingerScrollable", true);
        ui->webView_2->setProperty("FingerScrollable", true);
        ui->webView_UpdateScores->setProperty("FingerScrollable", true);
        ui->webView_URL->setProperty("FingerScrollable", true);
        ui->twSelect->setProperty("FingerScrollable", true);
        ui->twFavourites->setProperty("FingerScrollable", true);
        showOnlineLeague(714); //Italy - Serie A - 2009-10
    }

    ui->twFavourites->horizontalHeader()->setResizeMode(0,QHeaderView::ResizeToContents);
    ui->twFavourites->horizontalHeader()->setResizeMode(1,QHeaderView::ResizeToContents);
    ui->twFavourites->horizontalHeader()->setResizeMode(2,QHeaderView::ResizeToContents);
    ui->twFavourites->horizontalHeader()->setResizeMode(3,QHeaderView::ResizeToContents);
    ui->twFavourites->horizontalHeader()->setResizeMode(4,QHeaderView::ResizeToContents);

    connect(ui->twSelect,SIGNAL(itemClicked(QTreeWidgetItem*,int)),this,SLOT(showSelectedEvent(QTreeWidgetItem*)));
}

void MainWindow::showSelectedEvent(QTreeWidgetItem *qtwiSelected)
{
    if (qtwiSelected->type() == typeSeason)
    {
        sSelectedSeason = qtwiSelected->text(0);
        sSelectedEvent = qtwiSelected->parent()->text(0);
        sSelectedRegion = qtwiSelected->parent()->parent()->text(0);
//        sSelectedSport = qtwiSelected->parent()->parent()->parent()->text(0);
        sSelectedSport = "Football";
//        qDebug() << sSelectedSeason << sSelectedEvent << sSelectedRegion << sSelectedSport;
        populateSeason(sSelectedSeason);
        ui->tabWidget->setCurrentWidget(ui->tab_3);
    }
}

void MainWindow::showOnlineLeague(int iSelectedSoccerDBID)
{
    QString sHTML;
    QString sSelectedSoccerDBID;
    QString sStyle;
    QPalette palette;
    sSelectedSoccerDBID.setNum(iSelectedSoccerDBID);

//    ui->centralWidget->parent()->setWsetWindowTitle(sSelectedEvent);

    this->setWindowTitle(sSelectedEvent);

    sStyle = "<style type='text/css'>"
    ".Date "
    "{"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        border-bottom-color: black;"
    "        border-bottom-width: 1px;"
    "        padding: 2px;"
    "        margin: 5px;"
    "        border-style: solid; "
    "        -webkit-border-radius: 3px;"
    "}"
    ".Match "
    "{"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        color: black; "
    "        border-width: 1px;"
    "        border-style: solid;"
    "        border-color: #0000FF;"
    "        margin: 2px;"
    "        padding: 2px 1px;"
    "        -webkit-border-radius: 3px;"
    "}"
    ".header {"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        font-weight: bold;"
    "        padding: 2px;    }"
    ".odd {"
    "        background-color: #ebebeb;"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        padding: 2px;    }"
    ".even {"
    "        font-family: verdana, geneva, arial, helvetica, sans-serif; "
    "        padding: 2px;    }"
    ".lines {background-color: #000;}"
    ".highlight {font-weight: bold;}"
    "</style>";

    // even :    "        background-color: #fff;"

    //background='qsportsevent1.jpg'
    sHTML = "<HTML>" + sStyle + "<body><script type='text/javascript' src='http://www.aragon.ws/soccerdb/getmatches.php?id=" + sSelectedSoccerDBID + "&date=latest&css=Match&cssDate=Date'></script></body></HTML>";
//    qDebug() << "sHTML :" << sHTML ;

    palette = ui->webView->palette();
    palette.setBrush(QPalette::Base, Qt::transparent);
    ui->webView->page()->setPalette(palette);
    ui->webView->setAttribute(Qt::WA_OpaquePaintEvent, false);
    ui->webView->setAttribute(Qt::WA_TranslucentBackground, true);
    ui->webView->setHtml(sHTML, QUrl::fromLocalFile(QDir::currentPath()));

    ui->webView->show();
//    qDebug() << "webView:" << ui->webView->page()->mainFrame()->toHtml();

    ui->webView_2->settings()->setAttribute(QWebSettings::JavascriptEnabled, true);
    sHTML = "<HTML>" + sStyle + "<body><script type='text/javascript' src='http://www.aragon.ws/soccerdb/gettable.php?id=" + sSelectedSoccerDBID + "&&showHeader=true&cssHeader=header&cssLines=lines&css1=odd&css2=even'></script></body></HTML>";
    palette = ui->webView_2->palette();
    palette.setBrush(QPalette::Base, Qt::transparent);
    ui->webView_2->page()->setPalette(palette);
    ui->webView_2->setAttribute(Qt::WA_OpaquePaintEvent, false);
    ui->webView_2->setAttribute(Qt::WA_TranslucentBackground, true);
    ui->webView_2->setHtml(sHTML, QUrl::fromLocalFile(QDir::currentPath()));
    ui->webView_2->show();

    if (!sSelectedURL.isEmpty())
    {
        ui->webView_URL->setUrl(sSelectedURL);
        ui->webView_URL->show();
    }
    else
    {
        sHTML = "<HTML><body><H2>No news URL selected for " + sSelectedEvent + "</H2></body></HTML>";
        palette = ui->webView_2->palette();
        palette.setBrush(QPalette::Base, Qt::transparent);
        ui->webView_URL->page()->setPalette(palette);
        ui->webView_URL->setAttribute(Qt::WA_OpaquePaintEvent, false);
        ui->webView_URL->setAttribute(Qt::WA_TranslucentBackground, true);
        ui->webView_URL->setHtml(sHTML, QUrl::fromLocalFile(QDir::currentPath()));
    }


//    qDebug() << "webView_2:" << ui->webView_2->page()->mainFrame()->toHtml();

// Display generated HTML in temp edit control //
//    ui->txtHTML->setText(ui->webView->);
}

bool MainWindow::existDatabase()
{

    QFile fDbFile;
    QString path;
    bool existDb;

#ifdef Q_OS_LINUX
        // NOTE: We have to store database file into user home folder in Linux
//            QString path(QDir::home().path());
        path = QDir::home().path();
        path.append(QDir::separator()).append("qsportsevent.db");
        path = QDir::toNativeSeparators(path);
#else
        path = "./qsportsevent.db" ;
        // NOTE: File exists in the application private folder, in Symbian Qt implementation
#endif
        fDbFile.setFileName(path);
//        qDebug() << "Db path:" << path;
//        qDebug() << "fDbFile.exists():" << fDbFile.exists();
        existDb = fDbFile.exists();

        if (existDb)
        {
            fDbFile.setPermissions(QFile::ReadOwner | QFile::WriteOwner | QFile::ReadUser |QFile::WriteUser);
            db = QSqlDatabase::addDatabase("QSQLITE");
            db.setDatabaseName(path);
            if (!db.open())
            {
                qDebug() << "Failed to connect";
                qDebug() << db.lastError();
            }
        }

        return existDb ;
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::loadMenu()
{
    QMenuBar *menuBar=new QMenuBar();
    QAction *showImportEvents=new QAction("Import Event",this);
    menuBar->addAction(showImportEvents);
    connect(showImportEvents,SIGNAL(triggered()),this,SLOT(showImportEvents()));
    QAction *showAbout=new QAction("About",this);
    menuBar->addAction(showAbout);
    connect(showAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
    setMenuBar(menuBar);
}

void MainWindow::showImportEvents()
{

    dlgImportEvents = new importevents;

    dlgImportEvents->show();
    if (dlgImportEvents->exec() == QDialog::Accepted)
    {
    }
//    populateEventCombo();
    populateSportCombo();
//    populateGroupCombo();
//    populateRoundCombo();
//    populateTeamCombo();
//    displayGames();
//    showStandings();
}


void MainWindow::displayGames()
{
    QSqlQuery qry;
    QString sql;
    QString sqlAppend1;
    QString sqlAppend2;
//    QSqlQueryModel *model = new QSqlQueryModel;
    QString str;
 //   QString sql ="SELECT * FROM Games ORDER BY gametime ASC";
/*
    QString sql ="SELECT games.gametime, games.venue, hometeam.name, awayteam.name, games.homegoals, games.awaygoals "
                 "FROM Games, teamgroups, teams as hometeam, teams as awayteam "
                 "WHERE games.awayteamrowid = awayteam.rowid "
                 "AND  games.hometeamrowid = hometeam.rowid "
                 "AND games.grouprowid = teamgroups.rowid "
                 "ORDER BY teamgroups.name, games.gametime ASC";
*/
//                 "WHERE games.awayteamrowid = awayteam.rowid ";
//                 "AND  games.hometeamrowid = hometeam.rowid "
//                 "AND games.grouprowid = teamgroups.rowid "
//                "ORDER BY teamgroups.name, games.gametime ASC";
//    QTableView *view;
//    tbwGames
/*
    sql ="SELECT * "
                 "FROM Games ";
    model->setQuery(sql,db); // DB is a QSqlDatabase object
    qDebug() << "lastError" << model->lastError();
    ui->tbwGames->setModel(model);

    QSqlQueryModel *model2 = new QSqlQueryModel;
    sql ="SELECT rowid, * from Games";
    model2->setQuery(sql,db); // DB is a QSqlDatabase object
    qDebug() << "lastError" << model2->lastError();
    ui->tbvGames->setModel(model2);

    QSqlQueryModel *model3 = new QSqlQueryModel;
    sql ="SELECT rowid, * from Teams";
    model3->setQuery(sql,db); // DB is a QSqlDatabase object
    qDebug() << "lastError" << model3->lastError();
    ui->tbvTeams->setModel(model3);

    QSqlQueryModel *model4 = new QSqlQueryModel;
    sql ="SELECT rowid, * from teamgroups";
    model4->setQuery(sql,db); // DB is a QSqlDatabase object
    qDebug() << "lastError" << model4->lastError();
    ui->tbvGroups->setModel(model4);
*/



    sql = "SELECT rowid, name from teamgroups "
          "WHERE eventrowid=:eventrowid";

    qry.prepare(sql);
    qry.bindValue("eventrowid:", iEventID);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    while (qry.next()) {
        //Default group is the first one.
        if (sSelectedGroup == "")
        {
            sSelectedGroup = qry.value(1).toString();
        }
        hGroups[qry.value(1).toString()] = qry.value(0).toInt();
//        qDebug() << qry.value(0).toString();
//        qDebug() << qry.value(1).toString();
    }

//    qDebug() << sSelectedGroup;

    sql = "SELECT rowid, name from teams ";
    if (sSelectedGroup != "All")
    {
        sqlAppend1 = " WHERE grouprowid=" + QString::number(hGroups.value(sSelectedGroup),10);
//        qDebug() << sqlAppend1;
//        qDebug() << hGroups.value(sSelectedGroup);
    }

    qry.prepare(sql + sqlAppend1);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    hTeams.clear();
    hStanding.clear();
//    qDebug() << hTeams.keys();
//    qDebug() << hTeams.values();

    while (qry.next()) {
        Standing stTeam;
        hTeams[qry.value(1).toString()] = qry.value(0).toInt();
        stTeam.sTeamName = qry.value(1).toString();
        stTeam.iPoints = 0;
        stTeam.iWins = 0;
        stTeam.iDraws = 0;
        stTeam.iLosses = 0;
        stTeam.iScored = 0;
        stTeam.iConceeded = 0;
        stTeam.iTeamRowID = qry.value(0).toInt();
        hStanding[qry.value(0).toInt()] = stTeam;
//        qDebug() << qry.value(1).toString() << qry.value(0).toString();
//        qDebug() << hTeams.keys();
//        qDebug() << hTeams.values();
    }

    sqlAppend1="";
    sqlAppend2="";
    sql ="SELECT grouprowid, gametime, hometeamrowid, awayteamrowid, homegoals, awaygoals, round from games ";
    if (sSelectedGroup != "All")
    {
        sqlAppend1 = " grouprowid=" + QString::number(hGroups.value(sSelectedGroup),10);
//        qDebug() << sqlAppend1;
//        qDebug() << hGroups.value(sSelectedGroup);
    }

    if (sSelectedRound != "All")
    {
        sqlAppend2 = " round='" + sSelectedRound + "'";
    }

    if (sqlAppend1 != "" && sqlAppend2 != "")
    {
        sql = sql + " WHERE " + sqlAppend1 + " AND " + sqlAppend2;
    }
    else if (sqlAppend1 != "")
    {
        sql = sql + " WHERE " + sqlAppend1 ;
    }
    else if (sqlAppend2 != "")
    {
        sql = sql + " WHERE " + sqlAppend2;
    }

    qry.prepare(sql);

//    qDebug() << sql;

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

//    qDebug() << "qry.size()" << qry.size();
    ui->twGames->clear();
//    ui->twGames->setAlternatingRowColors(true);

    ui->twGames->setRowCount(48);//qry.size());
    ui->twGames->setColumnCount(6);

//    qDebug() << hTeams.keys();
//    qDebug() << hTeams.values();
//    qDebug() << hGroups.keys();
//    qDebug() << hGroups.values();
    int row=0;
    while (qry.next()) {
        for (int column = 0; column < 6; column++)
        {
            switch (column)
            {
            case 0:
//                qDebug() << "Group:" << qry.value(column).toString();
                str = hGroups.key(qry.value(column).toInt());
//                qDebug() << "str" << str;
                break;
            case 2:
            case 3:
//                qDebug() << "Team:" << qry.value(column).toString();
                str = hTeams.key(qry.value(column).toInt());
//                qDebug() << "str" << str;
                break;
            case 1:
            case 4:
            case 5:
//                qDebug() << "item" << qry.value(column).toString();
                str = qry.value(column).toString();
                break;
            }
            QTableWidgetItem *newItem = new QTableWidgetItem(str);
            ui->twGames->setItem(row, column, newItem);
        }
        row++;
     }
    ui->twGames->resizeColumnsToContents();
    ui->twGames->setItemDelegateForColumn(4, new SpinBoxDelegate(ui->twGames));
    ui->twGames->setItemDelegateForColumn(5, new SpinBoxDelegate(ui->twGames));
    ui->twGames->setColumnWidth(4,40);
    ui->twGames->setColumnWidth(5,40);
}

void MainWindow::populateGroupCombo()
{
    QSqlQuery qry;

    qry.prepare("SELECT rowid, name "
                 "FROM teamgroups "
                 "WHERE eventrowid=:eventrowid");

    qry.bindValue(":eventrowid", iEventID);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    ui->cbGroups->clear();
    ui->cbGroups->addItem("All");
    while (qry.isValid())
    {
        ui->cbGroups->addItem(qry.value(1).toString());
        qry.next();
    }
}

void MainWindow::populateSportCombo()
{
    QSqlQuery qry;

    qry.prepare("SELECT DISTINCT sport "
                "FROM events "
                "ORDER BY sport ASC");

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    ui->twSelect->setColumnCount(1);
    QList<QTreeWidgetItem *> lSports;
//    QTreeWidgetItem qtwiSports;

//    ui->cbSport->clear();
    while (qry.isValid())
    {
//        ui->cbSport->addItem(qry.value(0).toString());
        QTreeWidgetItem *qtwiSports = new QTreeWidgetItem((QTreeWidget*)0, QStringList(qry.value(0).toString()),typeSport);
        qtwiSports->addChildren(getRegions(qry.value(0).toString()));
        lSports.append(qtwiSports);
//        lSports.append(new QTreeWidgetItem((QTreeWidget*)0, QStringList(qry.value(0).toString())));
        qry.next();
    }
    ui->twSelect->insertTopLevelItems(0, lSports);
    ui->twSelect->topLevelItem(0)->setExpanded(true);
    if (ui->twSelect->topLevelItem(0)->text(0) == "Football")
    {
        ui->twSelect->topLevelItem(0)->setText(0,"");
        ui->twSelect->topLevelItem(0)->setIcon(0, QIcon(":/images/icons/resource/sports/soccer_64.png"));
    }

}

QList<QTreeWidgetItem *> MainWindow::getRegions(QString sSport)
{
    QList<QTreeWidgetItem *> lRegions;
    QSqlQuery qry;

    qry.prepare("SELECT DISTINCT region "
                 "FROM events "
                 "WHERE sport=:sport "
                 "ORDER BY region ASC");
    qry.bindValue(":sport", sSport);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    while (qry.isValid())
    {

        QTreeWidgetItem *qtwiRegions = new QTreeWidgetItem((QTreeWidget*)0, QStringList(qry.value(0).toString()),typeRegion);
        qtwiRegions->addChildren(getEvents(sSport, qry.value(0).toString()));
        lRegions.append(qtwiRegions);

        qry.next();
    }
    return lRegions;
}

QList<QTreeWidgetItem *> MainWindow::getEvents(QString sSport, QString sRegion)
{
    QList<QTreeWidgetItem *> lEvents;
    QSqlQuery qry;

//    bool bFirst = true;
    qry.prepare("SELECT DISTINCT name "
                 "FROM events "
                 "WHERE sport=:sport and region=:region "
                 "ORDER BY name ASC");
    qry.bindValue(":sport", sSport);
    qry.bindValue(":region", sRegion);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    while (qry.isValid())
    {

        QTreeWidgetItem *qtwiEvents = new QTreeWidgetItem((QTreeWidget*)0, QStringList(qry.value(0).toString()),typeEvent);
        qtwiEvents->addChildren(getSeasons(sSport, sRegion, qry.value(0).toString()));
        lEvents.append(qtwiEvents);

        qry.next();
    }
    return lEvents;
}

QList<QTreeWidgetItem *> MainWindow::getSeasons(QString sSport, QString sRegion, QString sEventName)
{
    QList<QTreeWidgetItem *> lSeasons;
    QSqlQuery qry;

    qry.prepare("SELECT DISTINCT season "
                 "FROM events "
                 "WHERE sport=:sport and region=:region and name=:name "
                 "ORDER BY season DESC");
    qry.bindValue(":sport", sSport);
    qry.bindValue(":region", sRegion);
    qry.bindValue(":name", sEventName);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    while (qry.isValid())
    {
        lSeasons.append(new QTreeWidgetItem((QTreeWidget*)0, QStringList(qry.value(0).toString()),typeSeason));
//        QTreeWidgetItem *qtwiEvents = new QTreeWidgetItem((QTreeWidget*)0, QStringList(qry.value(0).toString()),typeEvent);
        qry.next();
    }
    return lSeasons;
}
void MainWindow::populateRegionCombo(QString sSport)
{
    QSqlQuery qry;

    qry.prepare("SELECT DISTINCT region "
                 "FROM events "
                 "WHERE sport=:sport");
    qry.bindValue(":sport", sSport);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

//    ui->cbRegion->clear();
    while (qry.isValid())
    {
//        ui->cbRegion->addItem(qry.value(0).toString());
        qry.next();
    }
}

void MainWindow::populateTeamCombo()
{
    QSqlQuery qry;
    QString sql;
    QString sqlAppend;

    sql = "SELECT rowid, name "
          "FROM teams ";

    if (sSelectedGroup != "All")
    {
        sqlAppend = "WHERE grouprowid=" + QString::number(hGroups.value(sSelectedGroup),10);
//        qDebug() << sqlAppend;
//        qDebug() << hGroups.value(sSelectedGroup);
    }

    qry.prepare(sql + sqlAppend);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    ui->cbTeam->clear();
    ui->cbTeam->addItem("All");
    while (qry.isValid())
    {
        ui->cbTeam->addItem(qry.value(1).toString());
        qry.next();
    }
}

void MainWindow::populateRoundCombo()
{
    QSqlQuery qry;
    int iMaxRound;

    qry.prepare("SELECT MAX(round) as maxround "
                 "FROM games ");

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();
    iMaxRound = qry.value(0).toInt();
    ui->cbRounds->clear();
    ui->cbRounds->addItem("All");

    for (int i=1; i<iMaxRound+1; i++)
    {
        ui->cbRounds->addItem(QString::number(i,10));
    }

}

void MainWindow::populateSeasonCombo(QString sSport, QString sRegion, QString sEventName)
{
    QSqlQuery qry;

    qry.prepare("SELECT DISTINCT season "
                 "FROM events "
                 "WHERE sport=:sport and region=:region and name=:name");
    qry.bindValue(":sport", sSport);
    qry.bindValue(":region", sRegion);
    qry.bindValue(":name", sEventName);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();
//    ui->cbSeason->clear();

    while (qry.isValid())
    {
//        ui->cbSeason->addItem(qry.value(0).toString());
        qry.next();
    }

}

void MainWindow::populateEventCombo(QString sSport, QString sRegion)
{
    QSqlQuery qry;


    //    bool bFirst = true;
    qry.prepare("SELECT DISTINCT name "
                 "FROM events "
                 "WHERE sport=:sport and region=:region");
    qry.bindValue(":sport", sSport);
    qry.bindValue(":region", sRegion);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

//    ui->cbEvents->clear();
    while (qry.isValid())
    {
/*        if (bFirst)
        {
            iEventID = qry.value(0).toInt() ;
            bFirst = false;
        }
*/
//        ui->cbEvents->addItem(qry.value(0).toString());
        qry.next();
    }

}

int MainWindow::populateFavourites()
{
    QSqlQuery qry;
    QString sql;
    int i, j;
    int iRowCount;

    i=0;

    sql ="SELECT showdefault, sport, region, name, url from favourites "
         "ORDER BY sport, region, name ";

    qry.prepare(sql);
//    qDebug() << sql;

    if (!qry.exec())
    {
//        qDebug() << qry.lastQuery();
//        qDebug() << qry.lastError();
    }

    iRowCount = ui->twFavourites->rowCount();
    for (j = 0; j<=iRowCount-1; j++)
    {
        ui->twFavourites->removeRow(0);
    }
    while (qry.next()) {
        ui->twFavourites->setRowCount(ui->twFavourites->rowCount()+1);
        QTableWidgetItem *newItem;

        newItem = new QTableWidgetItem(qry.value(0).toString()); //ShowDefault
        ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 0, newItem);

        if (qry.value(1).toString() == "Football")
        {
            newItem = new QTableWidgetItem(1);//add
            newItem->setIcon(QIcon(":/images/icons/resource/sports/soccer_64.png")); //Add Icon
            ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 1, newItem);
        }
        else
        {
            newItem = new QTableWidgetItem(qry.value(1).toString()); //Sport
            newItem->setFlags(Qt::NoItemFlags);
            ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 1, newItem);
        }
        newItem = new QTableWidgetItem(qry.value(2).toString()); //Region
        newItem->setFlags(Qt::NoItemFlags);
        ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 2, newItem);
        newItem = new QTableWidgetItem(qry.value(3).toString()); //Name
        newItem->setFlags(Qt::NoItemFlags);
        ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 3, newItem);
        newItem = new QTableWidgetItem(qry.value(4).toString()); //URL
        ui->twFavourites->setItem(ui->twFavourites->rowCount()-1, 4, newItem);
        i++;
    }
    isFavouritesListPopulated = true;
    return i;
}

void MainWindow::on_tabWidget_currentChanged ( int index )
{
    if (!isLeagueListPopulated)
    {
        populateSportCombo();
        isLeagueListPopulated = true;
    }
}

void MainWindow::on_twFavourites_clicked ( const QModelIndex & index )
{
    QSqlQuery qry;
    QString sql;
    QTableWidgetItem *qtwiItem;
    int row, column;

    row = index.row();
    column = index.column();

//    qtwiItem = ui->twFavourites->item(row,1);
//    sSelectedSport = qtwiItem->text();
    sSelectedSport = "Football";                // HARDCODED as the text property is no longer set when we use an icon...
    qtwiItem = ui->twFavourites->item(row,2);
    sSelectedRegion = qtwiItem->text();
    qtwiItem = ui->twFavourites->item(row,3);
    sSelectedEvent = qtwiItem->text();
    qtwiItem = ui->twFavourites->item(row,4);
    sSelectedURL = qtwiItem->text();

    sql = "SELECT season, soccerdbid from events "
          "WHERE name=:name and region=:region and sport=:sport "
          "ORDER BY season DESC";
    qry.prepare(sql);
    qry.bindValue(":name", sSelectedEvent);
    qry.bindValue(":region", sSelectedRegion);
    qry.bindValue(":sport", sSelectedSport);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (qry.next()) {
        sSelectedSeason = qry.value(0).toString();
        iSelectedSoccerDBID = qry.value(1).toInt();
    }

    populateSeason(sSelectedSeason);

    if (column != 4 && column != 0) // Don't update if Default or URL was clicked.
    {
        ui->tabWidget->setCurrentWidget(ui->tab_3);
    }
}

void MainWindow::on_twFavourites_cellChanged ( int row, int column )
{
    QSqlQuery qry;
    QString sql;
    QString sURL;
    int iDefault;
    QTableWidgetItem *qtwiItem;

    if ((column == 4 || column == 0) && isFavouritesListPopulated) //Default or URL
    {
        qtwiItem = ui->twFavourites->item(row,0);
        iDefault = qtwiItem->text().toInt();
        qtwiItem = ui->twFavourites->item(row,1);
//        sSelectedSport = qtwiItem->text();            HARDCODED AS we only have the icon now, not the text.
        sSelectedSport = "Football";
        qtwiItem = ui->twFavourites->item(row,2);
        sSelectedRegion = qtwiItem->text();
        qtwiItem = ui->twFavourites->item(row,3);
        sSelectedEvent = qtwiItem->text();
        qtwiItem = ui->twFavourites->item(row,4);
        sURL = qtwiItem->text();
        sSelectedURL = sURL;

        qry.prepare("UPDATE favourites SET showdefault=:showdefault, url=:url "
                    "WHERE name=:name and region=:region and sport=:sport ");

        qry.bindValue(":name", sSelectedEvent);
        qry.bindValue(":region", sSelectedRegion);
        qry.bindValue(":sport", sSelectedSport);
        qry.bindValue(":showdefault", iDefault);
        qry.bindValue(":url", sURL);

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }

        if (column == 4)
        {
            //Display News tab
            ui->tabWidget->setCurrentWidget(ui->tab_News);
        }
    }
}


void MainWindow::on_pbAddFavourite_clicked()
{

    QSqlQuery qry;
    QString sql;

    sql ="SELECT showdefault, sport, region, name, url from favourites "
         "WHERE sport=:sport and region=:region and name=:name";

    qry.prepare(sql);
//    qDebug() << sql;

//    qry.bindValue(":sport", sSelectedSport);
    qry.bindValue(":sport", "Football");
    qry.bindValue(":region", sSelectedRegion);
    qry.bindValue(":name", sSelectedEvent);


    if (!qry.exec())
    {
//        qDebug() << qry.lastQuery();
//        qDebug() << qry.lastError();
    }
    else
    {
        if (qry.next())
        {
            return; // A record with the selected keys already exists.
        }
    }


    qry.prepare("INSERT INTO favourites (showdefault, sport, region, name, url) VALUES "
                "(:showdefault, :sport, :region, :name, :url)");

    qry.bindValue(":showdefault", 0);
    qry.bindValue(":sport", "Football");            // Hardcoded as there is no other sport now...
    qry.bindValue(":region", sSelectedRegion);
    qry.bindValue(":name", sSelectedEvent);
    qry.bindValue(":url", "");

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
        qDebug() << qry.executedQuery();
        qDebug() << qry.boundValues();
    }
    else
    {
        isFavouritesListPopulated = false;
        populateFavourites();
    }

}

void MainWindow::on_pbRemoveFavourite_clicked()
{

    QSqlQuery qry;
    QTableWidgetItem *qtwiItem ;

    QString sql;
    int row;

    row =  ui->twFavourites->selectedItems().first()->row();

    qtwiItem = ui->twFavourites->item(row,1);
//    qDebug() << qtwiItem ;
//    qDebug() << qtwiItem->row();
//    qDebug() << qtwiItem->column();
//    sSelectedSport = qtwiItem->text();
    sSelectedSport = "Football";
//    qDebug() << sSelectedSport;
    qtwiItem = ui->twFavourites->item(row,2);
    sSelectedRegion = qtwiItem->text();
//    qDebug() << sSelectedRegion;
    qtwiItem = ui->twFavourites->item(row,3);
    sSelectedEvent = qtwiItem->text();
//    qDebug() << sSelectedEvent;

    qry.prepare("DELETE FROM favourites "
                "WHERE name=:name and region=:region and sport=:sport ");

    qry.bindValue(":sport", sSelectedSport);
    qry.bindValue(":region", sSelectedRegion);
    qry.bindValue(":name", sSelectedEvent);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
        qDebug() << qry.executedQuery();
        qDebug() << qry.boundValues();
    }
    else
    {
//        qDebug() << "Delete Event:" << sSelectedEvent;
        ui->twFavourites->removeRow(row);
    }

}

/*
void MainWindow::on_cbSport_activated(QString sSportName)
{
    sSelectedSport = sSportName;
    populateRegionCombo(sSportName);
//    displayGames();
//    showStandings();
}

void MainWindow::on_cbRegion_activated(QString sRegionName)
{
    sSelectedRegion = sRegionName;
    populateEventCombo(sSelectedSport, sSelectedRegion);
//    displayGames();
//    showStandings();
}

void MainWindow::on_cbEvents_activated(QString sEventName)
{
    sSelectedEvent = sEventName;
    populateSeasonCombo(sSelectedSport, sSelectedRegion, sSelectedEvent);
//    displayGames();
//    showStandings();
}
*/
void MainWindow::on_cbGroups_activated(QString sGroupName)
{
    sSelectedGroup = sGroupName;
    displayGames();
    showStandings();
}

//void MainWindow::on_cbSeason_activated(QString sSeason)
void MainWindow::populateSeason(QString sSeason)
{
    QSqlQuery qry;
    QString sql;

    sSelectedSeason = sSeason;
    sql = "SELECT rowid, soccerdbid from events "
          "WHERE name = :name and season = :season and region = :region";
    qry.prepare(sql);
    qry.bindValue(":name", sSelectedEvent);
    qry.bindValue(":season", sSelectedSeason);
    qry.bindValue(":region", sSelectedRegion);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (qry.next()) {
        iEventID = qry.value(0).toInt();
        iSelectedSoccerDBID = qry.value(1).toInt();
    }
    else
    {
        iEventID = -1;
    }

    showOnlineLeague(iSelectedSoccerDBID);
    populateGroupCombo();
    populateRoundCombo();
    displayGames();

}

void MainWindow::on_cbRounds_activated(QString sRound)
{
    sSelectedRound = sRound;
    displayGames();
}

void MainWindow::showAbout()
{
    QString message = "";
    QString version;

//    message.append(APP_NAME);
    message.append("QSportsEvent");
    message.append("-");
//    version = version.setNum(APP_VERSION);
    version = "0.0.5";
    message.append(version);
    message.append("\n by ");
//    message.append(AUTHOR);
    message.append("Magnus Lundgren (qsportsevent@gmail.com)\n");
    message.append("With special thanks to the maemo.org community for its input.\n");
    message.append("Special mention to Reflektorfalke, robbie, fgs, Haus3r, pantera1989, ....\n");
    message.append("This version of QSportsEvent would not be possible ");
    message.append("without the data provided by http://www.aragon.ws/soccerdb/.\n");
    message.append("Please visit that site and donate to its author, Jorge Aragon.\n");
    message.append("Future versions of QSportsEvent might use other data sources.\n");
//    message.append("\nFollow QSportsEvent on Twitter!");
    QMessageBox::about ( this, tr("About"), message);
}

void MainWindow::showStandings()
{
    QSqlQuery qry;
    QString sql;
    int iHomeTeamID;
    int iAwayTeamID;
    int iHomeGoals;
    int iAwayGoals;
    Standing stHomeTeam;
    Standing stAwayTeam;
    QTableWidgetItem *newItem;

    if (sSelectedGroup == "All" || sSelectedGroup == "")
    {
//        qDebug() << "Can't show standings for All groups" << sSelectedGroup;
        return;
    }


    sql ="SELECT hometeamrowid, awayteamrowid, homegoals, awaygoals from games "
         "WHERE grouprowid=" + QString::number(hGroups.value(sSelectedGroup),10);

//    str = hGroups.key(qry.value(column).toInt());
    qry.prepare(sql);
//    qDebug() << sql;

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
    while (qry.next()) {
        iHomeTeamID = qry.value(0).toInt();
        iAwayTeamID = qry.value(1).toInt();
        iHomeGoals = qry.value(2).toInt();
        iAwayGoals = qry.value(3).toInt();
        stHomeTeam = hStanding.value(iHomeTeamID);
        stAwayTeam = hStanding.value(iAwayTeamID);
//        qDebug() << iHomeTeamID << iAwayTeamID << iHomeGoals << iAwayGoals;
        if (iHomeGoals > iAwayGoals)
        {
            stHomeTeam.iPoints=stHomeTeam.iPoints + 3;
            stHomeTeam.iWins++;
            stAwayTeam.iLosses++;
        }
        else if (iHomeGoals < iAwayGoals)
        {
            stAwayTeam.iPoints=stAwayTeam.iPoints + 3;
            stHomeTeam.iLosses++;
            stAwayTeam.iWins++;
        }
        else
        {
            stHomeTeam.iPoints=stHomeTeam.iPoints + 1;
            stAwayTeam.iPoints=stAwayTeam.iPoints + 1;
            stHomeTeam.iDraws++;
            stAwayTeam.iDraws++;
        }

        stHomeTeam.iScored=stHomeTeam.iScored + iHomeGoals;
        stHomeTeam.iConceeded=stHomeTeam.iConceeded + iAwayGoals;
        stAwayTeam.iScored=stAwayTeam.iScored + iAwayGoals;
        stAwayTeam.iConceeded=stAwayTeam.iConceeded + iHomeGoals;

//        qDebug() << stHomeTeam.sTeamName << stHomeTeam.iPoints;
//        qDebug() << stAwayTeam.sTeamName << stAwayTeam.iPoints;
        hStanding[iHomeTeamID] = stHomeTeam;
        hStanding[iAwayTeamID] = stAwayTeam;
        }

    int j=0;
    QHash<int, Standing>::iterator i;

    ui->twStandings->clear();
    ui->twStandings->setRowCount(hStanding.count());
    ui->twStandings->setColumnCount(9);


    for (i = hStanding.begin(); i != hStanding.end(); ++i)
    {
        stAwayTeam = i.value();

        //Team Name
        newItem = new QTableWidgetItem(stAwayTeam.sTeamName);
//        qDebug() << j << stAwayTeam.sTeamName;
        ui->twStandings->setItem(j, 0, newItem);

        //Games played
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iWins +
                                                       stAwayTeam.iDraws +
                                                       stAwayTeam.iLosses,10));
//        qDebug() << j << QString::number(stAwayTeam.iPoints,10);
        ui->twStandings->setItem(j, 1, newItem);

        //Games won
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iWins,10));
//        qDebug() << j << QString::number(stAwayTeam.iWins,10);
        ui->twStandings->setItem(j, 2, newItem);

        //Games drawn
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iDraws,10));
//        qDebug() << j << QString::number(stAwayTeam.iDraws,10);
        ui->twStandings->setItem(j, 3, newItem);

        //Games lost
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iLosses,10));
//        qDebug() << j << QString::number(stAwayTeam.iLosses,10);
        ui->twStandings->setItem(j, 4, newItem);

        //Goals for
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iScored,10));
//        qDebug() << j << QString::number(stAwayTeam.iScored,10);
        ui->twStandings->setItem(j, 5, newItem);

        //Goals against
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iConceeded,10));
//        qDebug() << j << QString::number(stAwayTeam.iConceeded,10);
        ui->twStandings->setItem(j, 6, newItem);

        //Goal difference
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iScored-stAwayTeam.iConceeded,10));
//        qDebug() << j << QString::number(stAwayTeam.iScored-stAwayTeam.iConceeded,10);
        ui->twStandings->setItem(j, 7, newItem);

        //Points
        newItem = new QTableWidgetItem(QString::number(stAwayTeam.iPoints,10));
//        qDebug() << j << QString::number(stAwayTeam.iPoints,10);
        ui->twStandings->setItem(j, 8, newItem);

        j++;
    }
    ui->twStandings->resizeColumnsToContents();
}

void MainWindow::on_pbMatchRating_clicked()
{
    qDebug() << ui->txtHomeTeam->text();
    showRooster(ui->txtHomeTeam->text(), ui->txtAwayTeam->text());
}

void MainWindow::showRooster(QString sHomeTeam, QString sAwayTeam)
{
//    teamrooster oTeamRooster;
//    window.show();


    teamrooster *window= new teamrooster(this, sHomeTeam, sAwayTeam);
    // this is the only Maemo specific line here
//    window->setWindowTitle("This is second window");
    #ifdef Q_WS_MAEMO_5
        window->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
        window->setAttribute(Qt::WA_DeleteOnClose);
//    window->setHomeTeam(sHomeTeam);
//    window->setAwayTeam(sAwayTeam);
    window->show();
 /*
    if (!window) {
       window = new QMainWindow(this, 0);
           window->setAttribute(Qt::WA_Maemo5StackedWindow);
//       connect(window, SIGNAL(destroyed(QObject*)),this, SLOT(windowDestroyed(QObject*)));
       window->show();
       qDebug() << "Window" << window;
   }
*/
}

/*
void MainWindow::windowDestroyed(QObject* obj)
{
    disconnect(obj, SIGNAL(destroyed(QObject*)),this, SLOT(windowDestroyed(QObject*)));
    qDebug() << "No window" << window;
}
*/
