#ifndef IMPORTEVENTS_H
#define IMPORTEVENTS_H

#include <QDialog>
#include <QFile>

namespace Ui {
    class importevents;
}

class importevents : public QDialog {
    Q_OBJECT
public:
    importevents(QWidget *parent = 0);
    ~importevents();
    void purgeDatabase();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::importevents *ui;
    void importdelimited(QString filename);
    void import();
    void importTeams();
    void importGames(QString);
    int createGroup(QString);
    void createTeam(QString, int);
    void createGame(QStringList);
    void createEvent(QString, QString, QString, QString, int);
    void createDatabase();
    void importSoccerDBLeagues();
    void importTeamRooster();
    void createTeamRooster(QString, int, QString);

private slots:

    void on_pushBrowse_clicked();
    void on_pushImport_clicked();
    void on_pbSoccerDB_clicked();
    void on_pbTeamRooster_clicked();
};

#endif // IMPORTFLASHCARD_H
