#ifndef MAINWIN_H
#define MAINWIN_H

#include <QGraphicsView>
#include <QCoreApplication>
#include <QtDBus>
#include <QDebug>
#include <QtGui>
#include <QTextStream>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <QX11Info>
#include <QLabel>
#include <QApplication>
#include <QDesktopWidget>
#include <QCloseEvent>
#include <QEvent>
#include <QGraphicsScene>
#include <QGraphicsProxyWidget>
#include <libintl.h>
#include <gconf/gconf-client.h>
#include <qcontactmanager.h>
#include <qcontact.h>
#include <qcontactphonenumber.h>
#include <QContactThumbnail>
#include "mainview.h"
QTM_USE_NAMESPACE

class MainWin : public QGraphicsView
{
    Q_OBJECT
public:
    explicit MainWin(QWidget *parent = 0);
    ~MainWin();

    static bool myEventFilter(void *message, long int *);
    static const MainWin* instance();
    static MainWin *_mainWin;

private:
    QGraphicsScene *scene;
    QGraphicsProxyWidget *proxy;
    bool isPortrait;
    MainView *mainWidget;
    QLabel *label;
    QPointer<QContactManager> contactManager;
    QList<QContact> contactsList;
    bool isLocked;
    bool hildon_lock;
    bool hildon_canRotate;
    bool rotation_changed;
    QString unknownCaller;
    Atom _NET_ACTIVE_WINDOW;
    Atom _NET_SHOWING_DESKTOP;
    Atom _MB_CURRENT_APP_WINDOW;

signals:
    void imageReady(const QImage &image);
    
public slots:
    void _show();
    void onIncommingCall(const QDBusObjectPath &path, const QString &number);
    void onCallStatusChanged(const uint &status);
    void onTerminatedCall();
    void onOrientationChanged();
    void acceptCall();
    void rejectCall();
    void setContactDetails(const QString &number);
    void onContactManagerChanged();
    void onLockChanged(const QString &msg);
    void hildonLockRotation();
    void hildonRestoreRotation();
    void setDBus();
    void setXProperties();
    void bringWindowToTop();
    //void changeEvent(QEvent *event); //ahh ... QEvent::ActivationChange is not send in locked state
private slots:
    void getActiveWindow(Window &wId);
    bool isDesktop();
    void getMBActiveWindow(Window &wId);
};

#endif // MAINWIN_H
