#include "mainview.h"
#include <QDebug>

MainView::MainView(QWidget *parent) :
    QWidget(parent)
{
    setGeometry(0, 0, 480, 800);
    setContentsMargins(0,0,0,0);

    QString _style = QString("background-image: url(" + QApplication::applicationDirPath());

    //setStyleSheet("background-image: url(./images/wallpaper.png)"); low performance

    QSettings *settings = new QSettings(QSettings::IniFormat,
                                        QSettings::UserScope,
                                        "qslideanswer",
                                        "qslideanswer");

    if(!settings->contains("enable_wallpaper"))
        settings->setValue("enable_wallpaper", true); //create settings file if it doesn't exist

    if(settings->value("enable_wallpaper", true).toBool())
    {
        QWidget *background = new QWidget(this);
        background->setGeometry(0, 0, 480, 800);
        background->setStyleSheet(QString(_style + "/images/wallpaper.png)"));
    }
    settings->sync();
    delete settings;

    acceptButton = new QWidget(this);
    acceptButton->setAutoFillBackground(true);
    acceptButton->setGeometry(0, 550, 130, 130);
    acceptButton->setStyleSheet(QString(_style + "/images/accept.png)"));

    rejectButton = new QWidget(this);
    rejectButton->setAutoFillBackground(true);
    rejectButton->setGeometry(350, 550, 130, 130);
    rejectButton->setStyleSheet(QString(_style + "/images/reject.png)"));

    acceptDrag = false;
    rejectDrag = false;
    _acceptMousePress = false;


    numberLabel = new QLabel(this);
    numberLabel->setText("123435566");
    numberLabel->setStyleSheet("color:white;"
                         "font:28pt;"
                         "qproperty-alignment: AlignCenter;");
    numberLabel->setGeometry(0, 220, 480, 50);

    nameLabel = new QLabel(this);
    nameLabel->setText("Unknown number");
    nameLabel->setStyleSheet("color:white;"
                             "font:36pt;"
                             "qproperty-alignment: AlignCenter;");
    nameLabel->setGeometry(0, 150, 480, 50);


    greenArrow = new QWidget(this);
    greenArrow->setGeometry(acceptButton->width() + 10, acceptButton->pos().y() + acceptButton->height()/2 -4, 55, 14);
    greenArrow->setStyleSheet(QString(_style + "/images/greenarrow.png)"));
    greenArrow->setAutoFillBackground(true);


    redArrow = new QWidget(this);
    redArrow->setGeometry(width() - rejectButton->width() - 10 - 55, acceptButton->pos().y() + acceptButton->height()/2 -4, 55, 14);
    redArrow->setStyleSheet(QString(_style + "/images/redarrow.png)"));
    redArrow->setAutoFillBackground(true);
}

void MainView::mousePressEvent(QMouseEvent *event)
{
    if(!_acceptMousePress)
        return;

    offset = event->pos();
    if(offset.y() > 500 && offset.y() < 750 && offset.x() < acceptButton->width())
    {
        acceptDrag = true;
        greenArrow->hide();
    }
    else if(offset.y() > 500 && offset.y() < 750 && offset.x() > width() - rejectButton->width())
    {
        rejectDrag = true;
        redArrow->hide();
    }
}

void MainView::mouseMoveEvent(QMouseEvent *event)
{
    QPoint pos = event->pos();
    xpos = pos.x() - offset.x();

    if(acceptDrag)
    {
        if(xpos >= 0 && xpos <= (240 - rejectButton->width()/2))
            acceptButton->move(xpos, acceptButton->y());
    }
    else if(rejectDrag)
    {
        if(-xpos <= (240 - rejectButton->width()/2) && xpos <= 0)
            rejectButton->move(xpos + (480 - rejectButton->width()), rejectButton->y());
    }
}

void MainView::mouseReleaseEvent(QMouseEvent *)
{
    if(xpos >= (240 - rejectButton->width()/2) && acceptDrag)
        emit acceptCall();
    else if(-xpos >= (240 - rejectButton->width()/2) && rejectDrag)
        emit rejectCall();

    acceptButton->move(0, acceptButton->y());
    rejectButton->move(350, rejectButton->y());

    acceptDrag = false;
    rejectDrag = false;
    greenArrow->show();
    redArrow->show();
}


void MainView::setNumber(const QString &number)
{
    numberLabel->setText(number);
}

void MainView::setName(const QString &name)
{
    nameLabel->setText(name);
}

void MainView::acceptMousePress()
{
    _acceptMousePress = true;
}

void MainView::rejectMousePress()
{
    _acceptMousePress = false;
}
