#include "webpreview.h"
#include "ui_webpreview.h"
#include "platutil.h"
#include "qwebviewselectionsuppressor.h"

WebPreview::WebPreview(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::WebPreview)
{
    ui->setupUi(this);
    PlatUtil::configureWindow(this);
    new QWebViewSelectionSuppressor(ui->webView);
    ui->webView->settings()->setAttribute(QWebSettings::JavascriptEnabled, false);
}

WebPreview::~WebPreview()
{
    delete ui;
}

void WebPreview::showUrl(const QString &url)
{
    ui->webView->load(QUrl(url));

}
