#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include "redditsession.h"
#include <QDebug>
#include "commentview.h"
#include "platutil.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    setWindowTitle(tr("QReddit"));
    PlatUtil::configureWindow(this);

    m_ses = new RedditSession(this);
    ui->listWidget->setWordWrap(true);
    m_ses->start("");

    m_com = new CommentView(m_ses, this);
    setupCategories();
    connect(m_ses, SIGNAL(linksAvailable()), this, SLOT(populate()));
    connect(ui->listWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(itemActivated(QListWidgetItem*)));
    PlatUtil::toggleBusy(this, true);

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::populate()
{
    PlatUtil::toggleBusy(this, false);
    const REList& ents =  m_ses->getEntries();

    ui->listWidget->clear();
    for (int i=0; i < ents.count(); ++i) {;
        const RedditEntry& e = ents[i];
        QString desc = QString("%1 [%2]").arg(e.desc).arg(e.score);

        QListWidgetItem* it = new QListWidgetItem(desc);

        it->setData(Qt::UserRole, QVariant(i));
        ui->listWidget->addItem(it);
    }
    ui->listWidget->scrollToTop();


}


void MainWindow::itemActivated(QListWidgetItem* item)
{
    int idx = item->data(Qt::UserRole).toInt();
    const RedditEntry& e = m_ses->getEntries()[idx];

    //qDebug() << "use ent " << e.permalink;

    m_com->setEntry(e);
    m_com->show();
}

void MainWindow::setupCategories()
{
    QStringList cats = m_ses->getCategories();
    foreach (const QString& cat, cats) {
        menuBar()->addAction(cat, this, SLOT(changeCategory()));

    }
}

void MainWindow::changeCategory()
{
    QAction* act = qobject_cast<QAction*>(sender());
    if (!act) return;
    QString cat = act->text();
    m_ses->start(cat);
    setWindowTitle(cat);
    PlatUtil::toggleBusy(this, true);

}
