#include "commentview.h"
#include "ui_commentview.h"

#include "redditsession.h"
#include "platutil.h"

#include <QDesktopServices>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QLabel>
#include <QUrl>

#include "webpreview.h"

CommentView::CommentView(RedditSession* ses, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::CommentView),
    m_ses(ses)
{
    ui->setupUi(this);
    PlatUtil::configureWindow(this);
    connect(m_ses, SIGNAL(commentsAvailable()), this, SLOT(populate()));
    menuBar()->addAction(tr("Open link"), this, SLOT(openLink()));
    menuBar()->addAction(tr("Full"), this, SLOT(openBrowser()));
    connect(ui->textBrowser, SIGNAL(anchorClicked(QUrl)), this, SLOT(anchorClicked(QUrl)));
    m_web = new WebPreview(this);

    ui->textBrowser->setOpenLinks(false);
}

CommentView::~CommentView()
{
    delete ui;
}

void CommentView::openBrowser()
{
    QDesktopServices::openUrl("http://www.reddit.com/" + m_entry.permalink);

}
void CommentView::openLink()
{
    QDesktopServices::openUrl(m_entry.url);

}

namespace {

QString makeAnchorText(const QString& url)
{
    return QString("<h2><a href=\"show\">%1</a></h2>").arg(url);
}

}

void CommentView::setEntry(const RedditEntry &e)
{
    m_entry = e;    
    m_ses->fetchComments(e.permalink);
    setWindowTitle(e.desc);
    PlatUtil::toggleBusy(this, true);

    // bah, we don't want thumbnails anymore - just hit preview directly
    // if we have direct image link

    QString suffix = m_entry.url.right(3).toLower();
    if (m_entry.thumbnail.length() || suffix == "jpg" || suffix == "png" || suffix == "gif") {
        m_web->show();
    }

    /*
    if (m_entry.thumbnail.length()) {
        QNetworkRequest req(m_entry.thumbnail);
        QNetworkReply* reply = m_ses->m_net->get(req);
        connect(reply, SIGNAL(finished()), this, SLOT(thumbnailFetched()));
        ui->m_thumbnailButton->setVisible(true);
    } else {
        ui->m_thumbnailButton->setVisible(false);
    }
    */
    ui->textBrowser->setHtml(makeAnchorText(m_entry.url));
    m_web->showUrl(m_entry.url);
    m_web->setWindowTitle(m_entry.desc);

}

void CommentView::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CommentView::populate()
{
    PlatUtil::toggleBusy(this, false);
    ui->textBrowser->clear();

    if (m_ses->comments().length() < 3) {
        m_web->show();
    }
    QString coms = m_ses->comments().join("<hr/>");
    QString all = QString("%1<p>%2</p>").arg(makeAnchorText(m_entry.url)).arg(coms);
    ui->textBrowser->setHtml(all);
}

/*
void CommentView::thumbnailFetched()
{
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());
    if (!reply)
        return;

    QImage* img = new QImage;
    img->load(reply, NULL);
    QIcon icon;
    icon.addPixmap(QPixmap::fromImage(*img));
    ui->m_thumbnailButton->setIcon(icon);
    delete img;
    reply->deleteLater();

}

*/
void CommentView::anchorClicked(const QUrl &url)
{
    if (url.toString()  == "show")
        m_web->show();
}
