#include "commentview.h"
#include "ui_commentview.h"

#include "redditsession.h"
#include "platutil.h"

#include <QDesktopServices>

CommentView::CommentView(RedditSession* ses, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::CommentView),
    m_ses(ses)
{
    ui->setupUi(this);
    PlatUtil::configureWindow(this);
    connect(m_ses, SIGNAL(commentsAvailable()), this, SLOT(populate()));
    menuBar()->addAction(tr("Open link"), this, SLOT(openLink()));
    menuBar()->addAction(tr("Full"), this, SLOT(openBrowser()));

}

CommentView::~CommentView()
{
    delete ui;
}

void CommentView::openBrowser()
{
    QDesktopServices::openUrl("http://www.reddit.com/" + m_entry.permalink);

}
void CommentView::openLink()
{
    QDesktopServices::openUrl(m_entry.url);

}

void CommentView::setEntry(const RedditEntry &e)
{
    m_entry = e;
    m_ses->fetchComments(e.permalink);
    setWindowTitle(e.desc);
    PlatUtil::toggleBusy(this, true);

}

void CommentView::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CommentView::populate()
{
    PlatUtil::toggleBusy(this, false);
    ui->textBrowser->clear();

    QString coms = m_ses->comments().join("<hr/>");
    QString all = "<p>"+coms+ "</p>";

    ui->textBrowser->setHtml(all);
}
