// checksum 0xa193 version 0x30001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>
#include <QFileDialog>
#include <QImage>
#include <QMessageBox>
#include <qrencode.h>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::on_actionQuit_triggered()
{
    close();
}

void MainWindow::on_actionAbout_Qt_triggered()
{
    QMessageBox::aboutQt(this, "About Qt");
}

void MainWindow::on_actionAbout_triggered()
{
    QMessageBox::about(this, "About this", "Bye polE!");
}

void MainWindow::on_pushButton_clicked()
{
    QRcode *qrcode = QRcode_encodeString(ui->qrtext->toPlainText().toStdString().c_str(), 0, static_cast<QRecLevel>(ui->level->currentIndex()), QR_MODE_8, 1);
    if(qrcode)
    {
        QImage image(qrcode->width, qrcode->width, QImage::Format_RGB32);
        for(int y = 0; y!= qrcode->width; ++y)
        {
            for(int x = 0; x!= qrcode->width; ++x)
            {
                unsigned char tmp = qrcode->data[(y*qrcode->width)+x];
                image.setPixel(x, y, ((tmp & 0x1) ? 0xFFFFFFFF : 0xFF000000));
            }
        }
        ui->qrpicture->setPixmap(QPixmap::fromImage(image.scaled(qrcode->width*ui->scalefac->value(), qrcode->width*ui->scalefac->value())));
    }
    QRcode_free(qrcode);
}

void MainWindow::on_action_Save_to_png_triggered()
{
    ui->qrpicture->pixmap()->save(QFileDialog::getSaveFileName(this, "Save to .png", "/home/user/MyDocs/.images", "PNG Images (*.png)"), "PNG");
}
