#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);

    QSettings settings("qradio", "settings");

    int currentSet = settings.value("currentSet", 1).toInt();

    switch (currentSet)
    {
    case (1): ui->set1RadioButton->setChecked(true); break;
    case (2): ui->set2RadioButton->setChecked(true); break;
    case (3): ui->set3RadioButton->setChecked(true); break;
    }

    QString set1Name = settings.value("set1Name", "set1").toString();
    QString set2Name = settings.value("set2Name", "set2").toString();
    QString set3Name = settings.value("set3Name", "set3").toString();

    ui->set1RenameButton->setText(set1Name);
    ui->set1RadioButton->setText(set1Name);
    ui->set2RenameButton->setText(set2Name);
    ui->set2RadioButton->setText(set2Name);
    ui->set3RenameButton->setText(set3Name);
    ui->set3RadioButton->setText(set3Name);

    QString fontName = settings.value("fontName", "Digital-7").toString();
    ui->fontComboBox->setCurrentFont(fontName);
    int freqLabelFontSize=settings.value("currentFreqFontSize", 140).toInt();
    ui->freqSpinBox->setValue(freqLabelFontSize);
    int rdsSize = settings.value("rdsLabelsFontSize", 16).toInt();
    ui->rdsSpinBox->setValue(rdsSize);
    int buttonsSize = settings.value("buttonsFontSize", 20).toInt();
    ui->buttonsSpinBox->setValue(buttonsSize);
    int stationsSize = settings.value("stationListFontSize", 20).toInt();
    ui->listSpinBox->setValue(stationsSize);

    bool inizializeAtStartUp = settings.value("inizializeAtStartUp", false).toBool();
    ui->inizializeAtStartUpcheckBox->setChecked(inizializeAtStartUp);
    bool resumeAfterCall = settings.value("resumeAfterCall", false).toBool();
    ui->resumeAfterCallCheckBox->setChecked(resumeAfterCall);
    bool cameraFocusButtonUsed = settings.value("cameraFocusButtonUsed", true).toBool();
    ui->cameraFocusButtonUsedCheckBox->setChecked(cameraFocusButtonUsed);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::on_set1RenameButton_clicked()
{
    bool ok;
    QString nameTemp = QInputDialog::getText(this, tr("Set1 Rename"), tr("Insert Set1 Name:"), QLineEdit::Normal, ui->set1RadioButton->text(), &ok , 0);
    if (!ok) return;

    ui->set1RadioButton->setText(nameTemp);
    ui->set1RenameButton->setText(nameTemp);

}

void SettingsDialog::on_set2RenameButton_clicked()
{
    bool ok;
    QString nameTemp = QInputDialog::getText(this, tr("Set2 Rename"), tr("Insert Set2 Name:"), QLineEdit::Normal, ui->set2RadioButton->text(), &ok , 0);
    if (!ok) return;

    ui->set2RadioButton->setText(nameTemp);
    ui->set2RenameButton->setText(nameTemp);
}

void SettingsDialog::on_set3RenameButton_clicked()
{
    bool ok;
    QString nameTemp = QInputDialog::getText(this, tr("Set3 Rename"), tr("Insert Set3 Name:"), QLineEdit::Normal, ui->set3RadioButton->text(), &ok , 0);
    if (!ok) return;

    ui->set3RadioButton->setText(nameTemp);
    ui->set3RenameButton->setText(nameTemp);
}

void SettingsDialog::on_saveButton_clicked()
{
    int set;
    if (ui->set1RadioButton->isChecked()) set=1;
    if (ui->set2RadioButton->isChecked()) set=2;
    if (ui->set3RadioButton->isChecked()) set=3;


    QSettings settings("qradio", "settings");
    settings.setValue("currentSet", set);
    settings.setValue("set1Name", ui->set1RadioButton->text());
    settings.setValue("set2Name", ui->set2RadioButton->text());
    settings.setValue("set3Name", ui->set3RadioButton->text());

    settings.setValue("fontName", ui->fontComboBox->currentFont().toString());
    settings.setValue("currentFreqFontSize", ui->freqSpinBox->value());
    settings.setValue("rdsLabelsFontSize", ui->rdsSpinBox->value());
    settings.setValue("buttonsFontSize", ui->buttonsSpinBox->value());
    settings.setValue("stationListFontSize", ui->listSpinBox->value());

    settings.setValue("inizializeAtStartUp", ui->inizializeAtStartUpcheckBox->isChecked());
    settings.setValue("resumeAfterCall", ui->resumeAfterCallCheckBox->isChecked());
    settings.setValue("cameraFocusButtonUsed", ui->cameraFocusButtonUsedCheckBox->isChecked());

    emit saveButtonClicked();

    close();
}
