#include "managestations.h"
#include "emittingbutton.h"
#include <QScrollArea>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QAction>
#include <QMenu>
#include <QMenuBar>


ManageStations::ManageStations(QWidget *parent, QStringList list, QString fontName, int fontSize) :
    QMainWindow(parent)
{
    stations=list;

    createView();

    QAction *sortAction = new QAction("Sort", this);
    connect(sortAction, SIGNAL(triggered()), SLOT(sortActionTriggered()));
    QMenu *menu;
    menu = menuBar()->addMenu(tr("MENU TITLE"));
    menu->addAction(sortAction);

    QFont font(fontName, fontSize);

    this->setFont(font);




}

void ManageStations::createView()
{
    scrollArea = new QScrollArea;

    mainLayout = new QVBoxLayout;

    for (int i=0; i<stations.size(); i++)
    {
        QHBoxLayout *layout = new QHBoxLayout;
        QString string = stations.at(i);

        EmittingButton *upButton = new EmittingButton(scrollArea, 0, i);
        upButton->setIcon(QIcon("/usr/share/icons/hicolor/32x32/hildon/keyboard_move_up.png"));
        upButton->setText(NULL);
        connect(upButton, SIGNAL(buttonIsHold(int)), SLOT(stationMovedUp(int)));
        if (i==0) upButton->setEnabled(false);

        EmittingButton *downButton = new EmittingButton(scrollArea, 0, i);
        downButton->setIcon(QIcon("/usr/share/icons/hicolor/32x32/hildon/keyboard_move_down.png"));
        if (i==(stations.size()-1)) downButton->setEnabled(false);
        downButton->setText(NULL);
        connect(downButton, SIGNAL(buttonIsHold(int)), SLOT(stationMovedDown(int)));

        EmittingButton *stationButton = new EmittingButton(scrollArea, string.toDouble(), i);
        stationButton->setFixedWidth(450);
        connect(stationButton, SIGNAL(buttonClicked(int)), SLOT(stationPicked(int)));

        EmittingButton *deleteButton = new EmittingButton(scrollArea, 0, i);
        deleteButton->setIcon(QIcon("/usr/share/icons/hicolor/48x48/hildon/general_delete.png"));
        deleteButton->setText(NULL);
        connect(deleteButton, SIGNAL(buttonIsHold(int)), SLOT(stationDeleted(int)));

        layout->addWidget(upButton);
        layout->addWidget(downButton);
        layout->addWidget(stationButton);
        layout->addWidget(deleteButton);

        mainLayout->addLayout(layout);
    }

    QWidget *widget = new QWidget;
    widget->setLayout(mainLayout);
    widget->setFixedWidth(790);
    scrollArea->setWidget(widget);

    this->setCentralWidget(scrollArea);
}

void ManageStations::stationDeleted(int i)
{
    stations.removeAt(i);
    emit listChanged(stations);
    this->~QMainWindow();

}

void ManageStations::stationPicked(int n)
{

    emit setFreq(n);
}

void ManageStations::stationMovedUp(int i)
{
    stations.swap(i, i-1);
    emit listChanged(stations);
    this->~QMainWindow();
}

void ManageStations::stationMovedDown(int i)
{
    stations.swap(i, i+1);
    emit listChanged(stations);
    this->~QMainWindow();
}

void ManageStations::sortActionTriggered()
{
    stations.sort();
    emit listChanged(stations);
    this->~QMainWindow();
}
