#include "mainwindow.h"
#include "radio.h"
#include "emittingbutton.h"
#include "stationsdialog.h"
#include <QSettings>
#include <QProcess>
#include <QStringList>
#include <QString>
#include <QAction>
#include <QActionGroup>
#include <QMenu>
#include <QMenuBar>
#include <QDialog>
#include <QInputDialog>
#include <QMessageBox>
#include <QApplication>
#include <QFontDialog>
#include <QScrollArea>
#include <QVBoxLayout>
#include <QPalette>
#include <QProcess>
#include <QTimer>
#include <QTextEdit>

void maemoBanner(QString string)
{
    QProcess *myProcess = new QProcess;
    QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"" + string + "\"";
    myProcess->execute(program);
}


MainWindow::MainWindow(QWidget *parent) : QMainWindow(parent)
{
    w = new Radio();
    setCentralWidget(w);

    readSettings();
    readSetsName();
    createActions();
    readCurrentSet();
    createMenu();


    w->showQuickAccess(quickAccess);
    w->changeFont(currentFont, currentFreqFontSize, currentLabelsFontSize);

    connect(w, SIGNAL(fullScreenButtonClicked()), this, SLOT(goFullScreen()));
    connect(w, SIGNAL(showStationsDialog()), SLOT(stationsListActionTriggered()));

    fullScreen = false;

    w->populateBox(currentSet);

    w->setStationsListConnection(true);
    w->loadCurrentIndex();

    readLastFreq();

    setWindowTitle("QRadio");
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
	
	
    if (showCustomBackground)
    {
        QPalette p = palette();
        QPixmap pixmap1("/opt/qradio/background.png");
        p.setBrush(QPalette::Background,  pixmap1);
        setPalette(p);
    }

}

MainWindow::~MainWindow()
{
    saveSettings();
    saveCurrentSet();
    saveSetsName();
}

void MainWindow::createActions()
{
    set1Action = new QAction(set1Name, this);
    set1Action->setCheckable(true);
    connect(set1Action, SIGNAL(triggered()), SLOT(set1ActionTriggered()));

    set2Action = new QAction(set2Name, this);
    set2Action->setCheckable(true);
    connect(set2Action, SIGNAL(triggered()), SLOT(set2ActionTriggered()));

    set3Action = new QAction(set3Name, this);
    set3Action->setCheckable(true);
    connect(set3Action, SIGNAL(triggered()), SLOT(set3ActionTriggered()));

    setsActionGroup = new QActionGroup(this);
    setsActionGroup->addAction(set1Action);
    setsActionGroup->addAction(set2Action);
    setsActionGroup->addAction(set3Action);

    addStationAction = new QAction(tr("Add Station"), this);
    connect(addStationAction, SIGNAL(triggered()), SLOT(addStationTriggered()));

    manageStationsAction = new QAction(tr("Manage Stations"), this);
    connect(manageStationsAction, SIGNAL(triggered()), SLOT(manageStationsActionTriggered()));

    manualAction = new QAction(tr("Manual"), this);
    connect(manualAction, SIGNAL(triggered()), SLOT(manualActionTriggered()));

    stationsListAction = new QAction("Stations List", this);
    connect (stationsListAction, SIGNAL(triggered()), SLOT(stationsListActionTriggered()));

    aboutAction = new QAction("About", this);
    connect(aboutAction, SIGNAL(triggered()), SLOT(about()));

    aboutQtAction = new QAction("About Qt", this);
    connect(aboutQtAction, SIGNAL(triggered()), SLOT(aboutQt()));

    settingsAction = new QAction("Settings", this);
    connect(settingsAction, SIGNAL(triggered()), SLOT(settingsActionTriggered()));

    speakersAction = new QAction("Speakers", this);
    speakersAction->setCheckable(true);
    connect(speakersAction, SIGNAL(triggered()), SLOT(speakersActionTriggered()));

    autoScanAction = new QAction("AutoScan", this);
    connect(autoScanAction, SIGNAL(triggered()), SLOT(autoScanActionTriggered()));

    helpAction = new QAction("Help", this);
    connect(helpAction, SIGNAL(triggered()), SLOT(helpActionTriggered()));
}

void MainWindow::readSetsName()
{
    QSettings settings("Maemo", "qradio");
    set1Name = settings.value("set1Name", "Set1").toString();
    set2Name = settings.value("set2Name", "Set2").toString();
    set3Name = settings.value("set3Name", "Set3").toString();
}

void MainWindow::saveSetsName()
{
    QSettings settings("Maemo", "qradio");
    settings.setValue("set1Name", set1Name);
    settings.setValue("set2Name", set2Name);
    settings.setValue("set3Name", set3Name);
}

void MainWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("MENU TITLE"));
    menu->addActions(setsActionGroup->actions());
    menu->addAction(addStationAction);
    menu->addAction(manageStationsAction);
    menu->addAction(manualAction);
    menu->addAction(stationsListAction);
    menu->addAction(speakersAction);
    menu->addAction(autoScanAction);
    menu->addAction(helpAction);
    menu->addAction(settingsAction);
    menu->addAction(aboutAction);
    menu->addAction(aboutQtAction);

}

void MainWindow::addStationTriggered()
{
    double freq = w->getFreq();
    QStringList setTempList;

    switch (currentSet)
    {
    case (1) : setTempList = w->getSetList(1); break;
    case (2) : setTempList = w->getSetList(2); break;
    case (3) : setTempList = w->getSetList(3); break;
    }



    setTempList<<(QString::number(freq/1000000, 'f', 1)); w->setStationsList(setTempList);


    w->saveSetList(setTempList, currentSet);
    w->setStationsListConnection(false);
    w->populateBox(currentSet);
    w->setLastIndex();
    w->setStationsListConnection(true);
}

void MainWindow::readCurrentSet()
{
    QSettings settings("Maemo", "qradio");
    currentSet = settings.value("currentSet", 1).toInt();

    switch (currentSet)
    {
        case (1) : set1Action->setChecked(true); break;
        case (2) : set2Action->setChecked(true); break;
        case (3) : set3Action->setChecked(true); break;
    }
}

void MainWindow::saveCurrentSet()
{
    QSettings settings("Maemo", "qradio");
    settings.setValue("currentSet", currentSet);
}

void MainWindow::set1ActionTriggered()
{
    currentSet = 1;
    saveCurrentSet();
    w->setStationsListConnection(false);;
    w->populateBox(1);
    w->setStationsListConnection(true);

}

void MainWindow::set2ActionTriggered()
{
     currentSet = 2;
     saveCurrentSet();
     w->setStationsListConnection(false);
     w->populateBox(2);
     w->setStationsListConnection(true);
}

void MainWindow::set3ActionTriggered()
{
     currentSet = 3;
     saveCurrentSet();
     w->setStationsListConnection(false);
     w->populateBox(3);
     w->setStationsListConnection(true);
}

void MainWindow::manualActionTriggered()
{
    bool ok;
    double manualFreq = QInputDialog::getDouble(this, tr("Manual Freq"), tr("Frequence"), 87.50, 76.0, 108.0, 1, &ok, 0);
    if (ok) w->setFreq(manualFreq*1000000);
}

void MainWindow::stationsListActionTriggered()
{
    QStringList stats;

    switch (currentSet)
    {
    case (1) : stats = w->getSetList(1); break;
    case (2) : stats = w->getSetList(2); break;
    case (3) : stats = w->getSetList(3); break;
    }

    d=new StationsDialog(this, stats, currentFont, currentLabelsFontSize);
    connect(d, SIGNAL(setFreq(int)), w, SLOT(setFreq(int)));
    d->show();

}


void MainWindow::settingsActionTriggered()
{
    s=new SettingsWidget(this, set1Name, set2Name, set3Name, landscapeOrientation, currentFont, currentFreqFontSize, currentLabelsFontSize, monoMode, quickAccess, showCustomBackground);
    s->setAttribute(Qt::WA_Maemo5StackedWindow);
    s->setWindowFlags(s->windowFlags() | Qt::Window);
    s->setWindowTitle("Settings");

    connect(s, SIGNAL(set1NameChanged(QString)), SLOT(changeSet1Name(QString)));
    connect(s, SIGNAL(set2NameChanged(QString)), SLOT(changeSet2Name(QString)));
    connect(s, SIGNAL(set3NameChanged(QString)), SLOT(changeSet3Name(QString)));

    connect(s, SIGNAL(quickAccessChanged(bool)), SLOT(quickAccessChanged(bool)));
    connect(s, SIGNAL(monoModeChanged(bool)), SLOT(changeMonoMode(bool)));
    connect(s, SIGNAL(showBackgroundClicked(bool)), SLOT(setBackgroundVar(bool)));

    connect(s, SIGNAL(fontChanged(QString,int,int)), SLOT(changeFont(QString,int,int)));
    s->show();
}

void MainWindow::manageStationsActionTriggered()
{
    QStringList list;
    switch (currentSet)
    {
    case (1) : list = w->getSetList(1); break;
    case (2) : list = w->getSetList(2); break;
    case (3) : list = w->getSetList(3); break;
    }

    m = new ManageStations(this, list, currentFont, currentLabelsFontSize);
    connect(m, SIGNAL(listChanged(QStringList)), SLOT(listEdited(QStringList)));
    connect(m, SIGNAL(setFreq(int)), w, SLOT(setFreq(int)));

    m->setAttribute(Qt::WA_Maemo5StackedWindow);
    m->setWindowFlags(m->windowFlags() | Qt::Window);
    m->setWindowTitle("Manage Stations");

    m->show();
}

void MainWindow::about()
{
    QMessageBox::about(this, tr("About QRadio"),
                tr("<h2>QRadio 0.3.6</h2>"
                   "<p>"
                   "<p>Written by Giovanni Grammatico (ggiovanni88@yahoo.it)"));

}

/*void MainWindow::changeFont(QFont font, int n, int m)
{
    w->changeFont(font, n);
}
*/

void MainWindow::readSettings()
{
    QSettings settings("Maemo", "qradio");
    monoMode=settings.value("monoMode", false).toBool();
    quickAccess=settings.value("quickAccess", false).toBool();
    showCustomBackground=settings.value("showCustomBackground", false).toBool();
    currentFont=settings.value("currentFont", "Digital-7").toString();
    currentFreqFontSize=settings.value("currentFreqFontSize", 170).toInt();
    currentLabelsFontSize = settings.value("currentLabelsFontSize", 25).toInt();
}



/*void MainWindow::stationsListActionTriggered()
{
    stationsListCreate();
    wid->setWindowTitle("QRadio");
    wid->show();
}
*/

/*void MainWindow::stationsListCreate()
{
    widget = new QWidget;
    QScrollArea *scrollArea=new QScrollArea;
    QVBoxLayout *layout=new QVBoxLayout;

    QStringList tempList=w->getStationsList();

    for (int i=0; i<tempList.size(); i++)
    {
        QString tempString=tempList.at(i);
        EmittingButton *button=new EmittingButton(widget, tempString.toDouble());
        layout->addWidget(button);

        connect(button, SIGNAL(buttonClicked(int)), w, SLOT(setFreq(int)));
    }

    layout->addStretch();
    widget->setLayout(layout);
    widget->setMinimumWidth(455);

    scrollArea->setWidget(widget);
    scrollArea->setMinimumWidth(455);

    QLayout *layout1=new QVBoxLayout;
    layout1->addWidget(scrollArea);
    //QPushButton *button = new QPushButton("Close");

   // layout1->addWidget(button);

    wid = new QWidget;

    wid->setLayout(layout1);
    //connect(button, SIGNAL(clicked()), wid, SLOT(close()));

    QFont font(w->getFontType());
    QFont tempfont(font.toString(), 30);
    wid->setFont(tempfont);
    wid->setAttribute(Qt::WA_Maemo5PortraitOrientation);

}
*/

void MainWindow::goFullScreen()
{
    if (fullScreen)
    {
        fullScreen=false;
        this->showNormal();;
    }
    else
    {
        fullScreen = true;
        this->showFullScreen();
    }
}

void MainWindow::changeSet1Name(QString name)
{
    set1Action->setText(name);
    set1Name=name;
    saveSetsName();
}

void MainWindow::changeSet2Name(QString name)
{
    set2Action->setText(name);
    set2Name=name;
    saveSetsName();
}

void MainWindow::changeSet3Name(QString name)
{
    set3Action->setText(name);
    set3Name=name;
    saveSetsName();
}

void MainWindow::quickAccessChanged(bool quickAcc)
{
    if (quickAcc)
    {
        w->showQuickAccess(true);
        quickAccess=true;
    }
    else
    {
        w->showQuickAccess(false);
        quickAccess=false;
    }
}

void MainWindow::saveSettings()
{
    QSettings settings("Maemo", "qradio");
    settings.setValue("monoMode", monoMode);
    settings.setValue("quickAccess", quickAccess);
    settings.setValue("currentFont", currentFont);
    settings.setValue("currentFreqFontSize", currentFreqFontSize);
    settings.setValue("currentLabelsFontSize", currentLabelsFontSize);
    settings.setValue("showCustomBackground", showCustomBackground);
}

void MainWindow::changeMonoMode(bool mode)
{
    if (mode)
    {
        w->forceMono();
        monoMode=true;
    }
    else
    {
        w->forceStereo();
        monoMode=false;
    }
}

void MainWindow::aboutQt()
{
    QApplication::aboutQt();
}

void MainWindow::speakersActionTriggered()
{
    if (speakersAction->isChecked())
    {
        QProcess *myProcess = new QProcess;
        myProcess->execute("/opt/qradio/output.sh speaker");
    }
    else
    {
        QProcess *myProcess = new QProcess;
        myProcess->execute("/opt/qradio/output.sh headphone");
    }
}

void MainWindow::changeFont(QString fontString, int freqSize, int labelsSize)
{
    currentFont = fontString;
    currentFreqFontSize = freqSize;
    currentLabelsFontSize = labelsSize;

    w->changeFont(currentFont, freqSize, labelsSize);
}

void MainWindow::listEdited(QStringList stationList)
{

   w->saveSetList(stationList, currentSet);
   w->setStationsListConnection(false);
   w->populateBox(currentSet);
   w->setStationsListConnection(true);

}

void MainWindow::setBackgroundVar(bool showBack)
{
    maemoBanner("Restart App to reload Background");
    showCustomBackground = showBack;
}

void MainWindow::autoScanActionTriggered()
{
    int tempFreq = w->getFreq();
    if (tempFreq<87500000) tempFreq = 87500000;


    do
    {
        w->setFreq(tempFreq);
        if (w->getSignalStrenght()>0)
        {
            this->addStationTriggered();
            maemoBanner("Station found ("+ QString::number(tempFreq/1000) +")");
            //sleep(1);
        }
        tempFreq+=100000;

    }

    while (tempFreq<108000000);
    maemoBanner("AutoScan completed");
}

void MainWindow::helpActionTriggered()
{
    QMainWindow *helpWindow = new QMainWindow(this);
    helpWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
    helpWindow->setWindowFlags(helpWindow->windowFlags() | Qt::Window);
    helpWindow->setWindowTitle("QRadio");

    QTextEdit *textEdit = new QTextEdit;
    textEdit->setFixedHeight(900);
    textEdit->adjustSize();
    textEdit->setReadOnly(true);

    QScrollArea *scrollArea = new QScrollArea;

    QString text("Thanks for using this App. \n"
                 "\n"
                 "To change frequency, tap once on the blue arrows to change freq by 100kHz or hold the arrows down to seek up and down for a station. \n"
                 "The QuickAccess buttons are hidden by default, to show use the Settings Window. Tapping once on a QuickAccess button will change the freq to the shown value, holding it down will save the current freq to the selected button. \n"
                 "The small radio button on the bottom left will show the saved stations for the current set, the button in the bottom right will toggle the fullscreen mode and the white arrows will navigate throught the saved stations. \n"
                 "\n"
                 "This app gives you 3 sets of saved stations. To switch set just tap on it in the App menu. Set Names can be changed in settings window.\n"
                 "AddStation: tapping on it will save the current freq into the current set.\n"
                 "Manage Stations: tap on it to show the stations management window, where saved stations of the current set can be moved or deleted by holding down the relative icon. Tapping on the freq name button will change the current freq to that value.\n"
                 "Manual: tap on it to insert manually the desired frequency.\n"
                 "Stations List: same behavior of the small bottom left button.\n"
                 "Speakers: tap on it to toggle speakers output. To learn more about it check the Maemo.org topic about QRadio. \n"
                 "AutoScan: tapping on it will start the autoscan. Starting from the current freq, all stations will be saved into the current set.\n");
    QVBoxLayout *layout = new QVBoxLayout;
    layout->addWidget(textEdit);
    textEdit->setText(text);

    QWidget *widget = new QWidget;
    widget->setLayout(layout);

    scrollArea->setWidget(widget);
    scrollArea->setWidgetResizable(true);
    helpWindow->setCentralWidget(scrollArea);

    helpWindow->show();


}

void MainWindow::readLastFreq()
{
    QSettings settings("Maemo", "qradio");
    int lastFreq = settings.value("LastFreq", 87500000).toInt();
    w->setFreq(lastFreq);
}
