#include "clickableimage.h"

ClickableImage::ClickableImage(QWidget *parent) : QLabel(parent)
{
    timer = new QTimer;
    connect(timer, SIGNAL(timeout()), this, SLOT(timeout()));
}

void ClickableImage::mousePressEvent(QMouseEvent *eve )
{
    timer->start(1000);
        if ( eve->button() == Qt::LeftButton )
        emit leftButtonPressed(this);
        else if ( eve->button() == Qt::RightButton )
                emit rightButtonPressed(this);
        else if ( eve->button() == Qt::MidButton )
                emit middleButtonPressed(this);
}

void ClickableImage::mouseReleaseEvent(QMouseEvent *eve )
{
        if ( eve->button() == Qt::LeftButton )
         {
            if (timer->isActive())
            {
                timer->stop();
                emit leftButtonReleased(this);
            }
            else

            {

                timer->stop();
            }
        }

        else if ( eve->button() == Qt::RightButton )
                emit rightButtonReleased(this);
        else if ( eve->button() == Qt::MidButton )
                emit middleButtonReleased(this);
}

void ClickableImage::enterEvent(QEvent* eve)
{
        emit mouseEntered(this);
}

void ClickableImage::leaveEvent(QEvent* eve)
{
        emit mouseLeft(this);
}

void ClickableImage::timeout()
{
    emit leftButtonHold(this);
    timer->stop();
}
