#ifndef RADIO_H
#define RADIO_H

#include <QWidget>

class QLabel;
class QPushButton;
class QLCDNumber;
class QRadioTuner;
class QToolButton;
class ClickableImage;
class EmittingButton;
class QComboBox;
class QHBoxLayout;
class QVBoxLayout;

QT_USE_NAMESPACE

class Radio : public QWidget
{
    Q_OBJECT
public:
     explicit Radio(QWidget *parent = 0);
    ~Radio();

    void setStationsListConnection(bool);

    double getFreq();
    QStringList getSetList(int);

    void setStationsList(QStringList);

    void populateBox(int);

private:
    QLabel* stationName;
    QLabel* rdsData;
    QLabel* signal;
    QLabel *freq;

    EmittingButton *quickAccess[7];



    ClickableImage *leftImage;
    ClickableImage *rightImage;
    QPushButton *listButton;
    QPushButton *prevButton;
    QPushButton *nextButton;
    QPushButton *fullScreenButton;

    QStringList stationsList;
    QStringList set1List;
    QStringList set2List;
    QStringList set3List;

    //QuickAccessVariables
    double quickAccessDouble[7];

    QRadioTuner* radio;

    QComboBox *stationsBox;

    QHBoxLayout *quickAccessLayout;
    QVBoxLayout *mainLayout;

    void setLandscapeUI();
    void setPortraitUI();

    void saveSetLists();
    void readSetLists();

signals:
    void fullScreenButtonClicked();
    void showStationsDialog();

public slots:
        void freqUp();
        void freqDown();
        void searchUp();
        void searchDown();
        void freqChanged(int f);
        void signalChanged(int s);
        void stationPicked(QString);
        void setFreq(int);
        void saveCurrentFreq();
        void loadCurrentFreq();
        void nextButtonClicked();
        void prevButtonClicked();
        void setLastIndex();
        void restartRadio();
        void readRds();
        void saveCurrentIndex();
        void loadCurrentIndex();
        QFont getFontType();
        void showFullScreenClicked();
        void stationsButtonPressed();
        void quickAccessButtonIsHold(int);

        void readQuickAccess();
        void saveQuickAccess();

        void showQuickAccess(bool);
        void setQuickAccess();

        void changeFont(QString, int, int);

        void forceMono();
        void forceStereo();
        QStringList getStationsList();
        void saveSetList(QStringList, int);


};

#endif // RADIO_H
