#ifndef MANAGESTATIONS_H
#define MANAGESTATIONS_H

#include <QMainWindow>

class QScrollArea;
class QVBoxLayout;

class ManageStations : public QMainWindow
{
    Q_OBJECT

private:
    QStringList stations;
    QScrollArea *scrollArea;
    QVBoxLayout *mainLayout;

public:
    explicit ManageStations( QWidget *parent,  QStringList list, QString, int);

signals:
    void listChanged(QStringList);
    void setFreq(int);

public slots:
    void createView();

    void stationDeleted(int);
    void stationMovedUp(int);
    void stationMovedDown(int);
    void stationPicked(int);

    void sortActionTriggered();




};

#endif // MANAGESTATIONS_H
