#include "stationsdialog.h"
#include "emittingbutton.h"
#include <QGridLayout>

StationsDialog::StationsDialog(QWidget *parent, QStringList list, QString fontName, int fontSize) :
    QDialog(parent)
{
    QGridLayout *layout = new QGridLayout;
    QFont font(fontName, fontSize);

    this->setFont(font);



    for (int i=0; i<list.size(); i++)
    {
        QString string = list.at(i);
        EmittingButton *button = new EmittingButton(this, string.toDouble(), i);

        connect(button, SIGNAL(buttonClicked(int)), SLOT(stationPressed(int)));

        int riga=i/6;
        int colonna=i%6;

        layout->addWidget(button, riga, colonna);


    }

    this->setWindowTitle("Stations");
    this->setLayout(layout);
}

void StationsDialog::stationPressed(int n)
{
    QString string("Current Freq: ");
    double freq=n/100000;
    freq /= 10;
    string.append(QString::number(freq, 'f', 1));
    emit setFreq(n);
    this->setWindowTitle(string);
}
