#include "radio.h"
#include "mainwindow.h"
#include "emittingbutton.h"
#include <QRadioTuner>
#include <QLCDNumber>
#include <QLabel>
#include <QPushButton>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QProcess>
#include <QToolButton>
#include <QComboBox>
#include "clickableimage.h"
#include <QSettings>
#include <QTimer>
#include <QFile>
#include <QTextStream>
#include <QApplication>
#include <QtMaemo5/QMaemo5InformationBox>




void maemoBanner(QString string)
{
    QProcess *myProcess = new QProcess;
    QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"" + string + "\"";
    myProcess->execute(program);
}

Radio::Radio(QWidget *parent) :  QWidget(parent)
{

    radio = new QRadioTuner;

    connect(radio,SIGNAL(frequencyChanged(int)),this,SLOT(freqChanged(int)));
    connect(radio,SIGNAL(signalStrengthChanged(int)),this,SLOT(signalChanged(int)));


    if(radio->isBandSupported(QRadioTuner::FM))
    radio->setBand(QRadioTuner::FM);

    stationName = new QLabel("Station Name");
    QFont stationFont;
    stationFont.setUnderline(true);
    stationFont.setBold(true);
    stationName->setFont(stationFont);
    rdsData = new QLabel("RDS Data");
    QFont font;
    font.setPointSize(14);
    rdsData->setFont(font);

    //QFont freqFont("Digital-7", 170);
    freq = new QLabel;
    //freq->setFont(freqFont);
    freq->setFixedHeight(200);
    freq->setFixedWidth(400);
    //freq->setSmallDecimalPoint(false);
    //freq->setNumDigits(5);
    //freq->display(radio->frequency()/10000);


    signal = new QLabel;
    if (radio->isAvailable())
    signal->setText(tr("No Signal"));
    else
    signal->setText(tr("No radio found"));

    leftImage= new ClickableImage();
    leftImage->setPixmap(QPixmap("/opt/qradio/leftArrow.png"));
    leftImage->setMaximumSize(130,130);
    connect(leftImage, SIGNAL(leftButtonReleased(ClickableImage*)), SLOT(freqDown()));
    connect(leftImage, SIGNAL(leftButtonHold(ClickableImage*)), SLOT(searchDown()));

    rightImage= new ClickableImage();
    rightImage->setPixmap(QPixmap("/opt/qradio/rightArrow.png"));
    rightImage->setMaximumSize(130,130);
    connect(rightImage, SIGNAL(leftButtonReleased(ClickableImage*)), SLOT(freqUp()));
    connect(rightImage, SIGNAL(leftButtonHold(ClickableImage*)), SLOT(searchUp()));

    stationsBox = new QComboBox;
    stationsBox->setFixedWidth(100);

    listButton = new QPushButton;
    listButton->setIcon(QIcon("/usr/share/icons/hicolor/164x164/hildon/mediaplayer_main_button_radio.png"));
    listButton->setFixedWidth(120);
    listButton->setFixedHeight(70);
    listButton->setIconSize(QSize(80,80));
    connect(listButton, SIGNAL(clicked()), SLOT(stationsButtonPressed()));

    prevButton = new QPushButton;
    prevButton->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/general_back.png"));
    prevButton->setFixedWidth(120);
    prevButton->setIconSize(QSize(64,64));
    connect(prevButton, SIGNAL(clicked()), SLOT(prevButtonClicked()));

    nextButton = new QPushButton;
    nextButton->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/general_forward.png"));
    nextButton->setFixedWidth(120);
    nextButton->setIconSize(QSize(64,64));

    fullScreenButton = new QPushButton;
    fullScreenButton->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/general_fullsize.png"));
    fullScreenButton->setFixedWidth(120);
    fullScreenButton->setIconSize(QSize(64,64));
    connect(fullScreenButton, SIGNAL(clicked()), SLOT(showFullScreenClicked()));

    connect(nextButton, SIGNAL(clicked()), SLOT(nextButtonClicked()));

    quickAccessLayout = new QHBoxLayout;

    for (int i=0; i<7; i++)
    {
        quickAccess[i]=new EmittingButton(this, 102.2, i);
        quickAccess[i]->setFixedHeight(70);
        quickAccessLayout->addWidget(quickAccess[i]);
        connect(quickAccess[i], SIGNAL(buttonClicked(int)), SLOT(setFreq(int)));
        connect(quickAccess[i], SIGNAL(buttonIsHold(int)), SLOT(quickAccessButtonIsHold(int)));
    }

    setLandscapeUI();

    readSetLists();

    readRds();

    readQuickAccess();
    setQuickAccess();



    radio->setVolume(100);

    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), SLOT(readRds()));
    timer->start(5000);

    stationsBox->hide();




}

void Radio::setLandscapeUI()
{


    QHBoxLayout *labelLayout = new QHBoxLayout;
    QHBoxLayout *freqLayout = new QHBoxLayout;
    QHBoxLayout *buttonLayout = new QHBoxLayout;
    mainLayout = new QVBoxLayout;

    labelLayout->addWidget(stationName);
    labelLayout->addStretch();
    labelLayout->addWidget(signal);

    freqLayout->addWidget(leftImage);
    freqLayout->addWidget(freq);
    freqLayout->addWidget(rightImage);

    buttonLayout->addWidget(listButton, 0, Qt::AlignLeft);
    buttonLayout->addWidget(prevButton, 0, Qt::AlignLeft);
    buttonLayout->addStretch();
    buttonLayout->addWidget(stationsBox, 0, Qt::AlignCenter);
    buttonLayout->addStretch();
    buttonLayout->addWidget(nextButton, 0, Qt::AlignRight);
    buttonLayout->addWidget(fullScreenButton, 0, Qt::AlignRight);

    mainLayout->addLayout(labelLayout);
    mainLayout->addWidget(rdsData, 0, Qt::AlignLeft);
    mainLayout->addLayout(freqLayout);
    mainLayout->addLayout(quickAccessLayout);
    mainLayout->addLayout(buttonLayout);


    setLayout(mainLayout);

}

void Radio::freqUp()
    {
        int f = radio->frequency();
        f = f + radio->frequencyStep(QRadioTuner::FM);
    //  f = f + 50000;
        radio->setFrequency(f);
    }

void Radio::freqDown()
    {
        int f = radio->frequency();
        f = f - radio->frequencyStep(QRadioTuner::FM);
    //  f = f - 50000;
        radio->setFrequency(f);
    }

void Radio::searchUp()
    {
        radio->searchForward();
    }

void Radio::searchDown()
    {
        radio->searchBackward();
    }

void Radio::freqChanged(int)
    {
      double freqI=radio->frequency()/1000000.0;
      freq->setText(QString::number(freqI, 'f', 1));
    }

void Radio::signalChanged(int i)
    {
        if(radio->signalStrength() > 1)
        { signal->setText(QString::number(i).append('%'));
            radio->cancelSearch();


        }
        else
            signal->setText(QString::number(i).append('%'));
    }

Radio::~Radio()
    {
        saveSetLists();
        saveCurrentFreq();
        saveCurrentIndex();
        saveQuickAccess();

    radio->stop();
    QProcess *myProcess = new QProcess;
   // QString program = "dbus-send --system --type=method_call --dest=org.bluez $(dbus-send --system --print-reply --dest=org.bluez / org.bluez.Manager.ListAdapters | awk -F'\"' '/at/ {print $2}') org.bluez.Adapter.SetProperty string:Powered variant:boolean:false";
    myProcess->execute("/opt/qradio/disablebluetooth.sh");



}

void Radio::populateBox(int currentSet)
{
    switch (currentSet)
    {
    case (1) : stationsList = set1List; break;
    case (2) : stationsList = set2List; break;
    case (3) : stationsList = set3List; break;
    }

    stationsBox->clear();


    QStringList currentList = QStringList(stationsList);


    for (int i=0; i<currentList.size(); i++)
    {

        stationsBox->addItem(currentList.at(i));
    }
}

void Radio::stationPicked(QString str)
{
    int n;
    n=str.toDouble()*1000000;
    radio->setFrequency(n);
}

void Radio::saveSetLists()
{
    QSettings settings("Maemo", "qradio");
    settings.setValue("set1List", set1List);
    settings.setValue("set2List", set2List);
    settings.setValue("set3List", set3List);
}

void Radio::readSetLists()
{
    QSettings settings("Maemo", "qradio");
    set1List = settings.value("set1List").toStringList();
    set2List = settings.value("set2List").toStringList();
    set3List = settings.value("set3List").toStringList();
}

void Radio::setFreq(int num)
{
    radio->setFrequency(num);
}

void Radio::setStationsList(QStringList list)
{
    stationsList = list;
}

double Radio::getFreq()
{
    double freq = radio->frequency();
    return freq;
}

QStringList Radio::getSetList(int n)
{
    switch (n)
    {
    case (1) : return set1List; break;
    case (2) : return set2List; break;
    case (3) : return set3List; break;
    }
}

void Radio::loadCurrentFreq()
{
    /*QSettings settings("Maemo", "qradio");
    currentFreq = settings.value("currentFreq", 8870).toInt();*/
}

void Radio::saveCurrentFreq()
{
    /*QSettings settings("Maemo", "qradio");
    settings.setValue("currentFreq", currentFreq);*/
}

void Radio::saveCurrentIndex()
{

}

void Radio::nextButtonClicked()
{
    int currentStationsBoxIndex = stationsBox->currentIndex();
    if (stationsList.size() > currentStationsBoxIndex+1) stationsBox->setCurrentIndex(currentStationsBoxIndex+1);
    else stationsBox->setCurrentIndex(0);

}

void Radio::setLastIndex()
{
    stationsBox->setCurrentIndex(stationsList.size()-1);
}

void Radio::setStationsListConnection(bool conn)
{
    if (conn)
    {
        connect(stationsBox, SIGNAL(highlighted(QString)), this, SLOT(stationPicked(QString)));
        connect(stationsBox, SIGNAL(currentIndexChanged(QString)), this,  SLOT(stationPicked(QString)));
    }
    else
    {
        disconnect(stationsBox, SIGNAL(highlighted(QString)), this, SLOT(stationPicked(QString)));
        disconnect(stationsBox, SIGNAL(currentIndexChanged(QString)), this, SLOT(stationPicked(QString)));
    }
}

void Radio::restartRadio()
{


   // QMaemo5InformationBox::information(0,  ("Messaggio"),  QMaemo5InformationBox::DefaultTimeout);
    maemoBanner("Messaggio");

}

void Radio::readRds()
{
   // maemoBanner("read RDS");
    QFile file("/sys/class/i2c-adapter/i2c-3/3-0022/rds_ps");
    file.open(QIODevice::ReadOnly | QIODevice::Text);
      QString line;
      QTextStream t( &file );
      line = t.readLine();
      stationName->setText(line);
      file.close();
      QFile file2("/sys/class/i2c-adapter/i2c-3/3-0022/rds_rt");
      file2.open(QIODevice::ReadOnly | QIODevice::Text);

        QTextStream t2( &file2 );
        line = t2.readLine();
        rdsData->setText(line);
        file.close();
    signal->setText(QString::number(radio->signalStrength()).append('%'));

}

void Radio::loadCurrentIndex()
{
    QSettings settings("Maemo", "qradio");
        stationsBox->setCurrentIndex(settings.value("currentIndex").toInt());
}

QFont Radio::getFontType()
{
    QFont font = freq->font();
    return font;

}

void Radio::changeFont(QString font, int n, int m)
{
    QFont freqFont(font, n);
    freq->setFont(freqFont);

    QFont buttonFont(font, m);
    stationsBox->setFont(buttonFont);

    QFont stationFont(font, m);
    stationFont.setUnderline(true);
    stationName->setFont(stationFont);

    QFont rdsfont(font, m-3);
    rdsData->setFont(rdsfont);
    rdsData->setFont(rdsfont);

    signal->setFont(stationFont);

    for (int i=0; i<7; i++)
    {
        quickAccess[i]->setFont(buttonFont);
    }

}

/*void Radio::saveCurrentFont()
{
    QSettings settings("Maemo", "qradio");
    settings.setValue("currentFont", currentFont.toString());
    settings.setValue("currentFontSize", currentFontSize);
}*/

/*void Radio::loadCurrentFont()
{
    QSettings settings("Maemo", "qradio");
    QString currentFontString = settings.value("currentFont", "Digital-7").toString();
    currentFontSize = settings.value("currentFontSize", 170).toInt();
    currentFont = QFont(currentFontString, currentFontSize);
    changeFont(currentFont, currentFontSize);
}*/

void Radio::forceMono()
{
    radio->setStereoMode(QRadioTuner::ForceMono);
    maemoBanner("Radio set to Mono Mode");
}

void Radio::forceStereo()
{
    radio->setStereoMode(QRadioTuner::ForceStereo);
    maemoBanner("Radio set to Stereo Mode");
}

QStringList Radio::getStationsList()
{
    return stationsList;
}

void Radio::showFullScreenClicked()
{
    emit fullScreenButtonClicked();
}

void Radio::quickAccessButtonIsHold(int i)
{
    double freqz=(radio->frequency())/1000000.0;
    quickAccess[i]->setText(QString::number(freqz, 'f', 1 ));
    quickAccessDouble[i]=freqz;

}

void Radio::showQuickAccess(bool show)
{
    if (!show)

    {
       freq->setFixedHeight(250);
        for (int i=0; i<7; i++)
        {
            quickAccess[i]->hide();
        }
    }
    else
    {
        freq->setFixedHeight(200);
        for (int i=0; i<7; i++)
        {
            quickAccess[i]->show();
        }
    }
}

void Radio::saveQuickAccess()
{
    QStringList list;
    for (int i=0; i<7; i++)
    {
        list.append(QString::number(quickAccessDouble[i], 'f', 1));
    }

    QSettings settings("Maemo", "qradio");
    settings.setValue("quickAccessList", list);
}

void Radio::readQuickAccess()
{
    QSettings settings("Maemo", "qradio");
    QStringList list=settings.value("quickAccessList").toStringList();
    QString temp;

    for (int i=0; i<list.size(); i++)
    {
        temp=list.at(i);
        quickAccessDouble[i]=temp.toDouble();
    }
}

void Radio::setQuickAccess()
{
    for (int i=0; i<7; i++)
    {
        quickAccess[i]->setText(QString::number(quickAccessDouble[i], 'f', 1));
    }
}

void Radio::prevButtonClicked()
{
    int currentStationsBoxIndex = stationsBox->currentIndex();
    if (currentStationsBoxIndex==0) stationsBox->setCurrentIndex(stationsList.size()-1);
    else stationsBox->setCurrentIndex(currentStationsBoxIndex-1);
}

void Radio::saveSetList(QStringList list, int index)
{
    switch (index)
    {
    case (1) : set1List = list; break;
    case (2) : set2List = list; break;
    case (3) : set3List = list; break;
    }

}

void Radio::stationsButtonPressed()
{
    emit showStationsDialog();
}
