#include "fontdialog.h"
#include <QFontComboBox>
#include <QHBoxLayout>
#include <QSpinBox>
#include <QPushButton>



FontDialog::FontDialog(QWidget *parent) :
    QDialog(parent)
{
    QHBoxLayout *layout = new QHBoxLayout;
    fontBox = new QFontComboBox;
    fontBox->setCurrentFont(currentFont);
    sizeBox = new QSpinBox;
    sizeBox->setMinimum(40);
    sizeBox->setMaximum(200);
    sizeBox->setValue(currentFontSize);
    saveButton=new QPushButton("Save");
    connect(saveButton, SIGNAL(clicked()), SLOT(saveButtonClicked()));
    layout->addWidget(fontBox);
    layout->addWidget(sizeBox);
    layout->addStretch();
    layout->addWidget(saveButton);
    fontBox->setFontFilters(QFontComboBox::ScalableFonts);
    setLayout(layout);

    setWindowTitle("Font Dialog");

}

void FontDialog::saveButtonClicked()
{
    emit saveButtonClicked(fontBox->currentFont(), sizeBox->value());
    this->hide();
}

void FontDialog::setCurrent()
{
    sizeBox->setValue(currentFontSize);
    fontBox->setCurrentFont(currentFont);
}
