#include "mainwindow.h"
#include "radio.h"
#include <QSettings>
#include <QStringList>
#include <QString>
#include <QAction>
#include <QActionGroup>
#include <QMenu>
#include <QMenuBar>
#include <QDialog>
#include <QInputDialog>
#include <QMessageBox>
#include <QApplication>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    w = new Radio();

    setCentralWidget(w);

    loadSetsName();
    createActions();
    createMenu();
    loadCurrentSet();



    setWindowTitle("QRadio");

    w->populateBox();
}

MainWindow::~MainWindow()
{

}

void MainWindow::createActions()
{
    set1Action = new QAction(set1Name, this);
    set1Action->setCheckable(true);
    connect(set1Action, SIGNAL(triggered()), SLOT(set1ActionTriggered()));
    set2Action = new QAction(set2Name, this);
    set2Action->setCheckable(true);
    connect(set2Action, SIGNAL(triggered()), SLOT(set2ActionTriggered()));
    set3Action = new QAction(set3Name, this);
    set3Action->setCheckable(true);
    connect(set3Action, SIGNAL(triggered()), SLOT(set3ActionTriggered()));
    setsActionGroup = new QActionGroup(this);
    setsActionGroup->addAction(set1Action);
    setsActionGroup->addAction(set2Action);
    setsActionGroup->addAction(set3Action);
    addStationAction = new QAction(tr("Add Station"), this);
    connect(addStationAction, SIGNAL(triggered()), SLOT(addStationTriggered()));
    deleteStationAction = new QAction(tr("Delete Station"), this);
    connect(deleteStationAction, SIGNAL(triggered()), SLOT(deleteStationActionTriggered()));
    manualAction = new QAction(tr("Manual"), this);
    connect(manualAction, SIGNAL(triggered()), SLOT(manualActionTriggered()));
    renameSetsAction = new QAction(tr("Rename Sets"), this);
    connect(renameSetsAction, SIGNAL(triggered()), SLOT(renameSetsActionTriggered()));
    restartRadioAction = new QAction(tr("Restart Radio"), this);
    connect(restartRadioAction, SIGNAL(triggered()), w, SLOT(restartRadio()));
    aboutAction = new QAction("About", this); connect(aboutAction, SIGNAL(triggered()), SLOT(about()));
    aboutQtAction = new QAction("About Qt", this); connect(aboutQtAction, SIGNAL(triggered()), SLOT(aboutQt()));

}

void MainWindow::loadSetsName()
{
    QSettings settings("Maemo", "qradio");
    set1Name = settings.value("set1Name", "Set1").toString();
    set2Name = settings.value("set2Name", "Set2").toString();
    set3Name = settings.value("set3Name", "Set3").toString();
}

void MainWindow::saveSetsName()
{
    QSettings settings("Maemo", "qradio");
    settings.setValue("set1Name", set1Name);
    settings.setValue("set2Name", set2Name);
    settings.setValue("set3Name", set3Name);
}

void MainWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("MENU TITLE"));
    menu->addActions(setsActionGroup->actions());
    menu->addAction(addStationAction);
    menu->addAction(deleteStationAction);
    menu->addAction(manualAction);
    menu->addAction(renameSetsAction);
    //menu->addAction(restartRadioAction);
    menu->addAction(aboutAction);
    menu->addAction(aboutQtAction);
}

void MainWindow::addStationTriggered()
{
    int freq = w->currentFreq;

    switch (currentSet)
    {
    case (1) :  w->set1List<<(QString::number(freq)); w->stationsList = w->set1List; break;
    case (2) :  w->set2List<<(QString::number(freq)); w->stationsList = w->set2List; break;
    case (3) :  w->set3List<<(QString::number(freq)); w->stationsList = w->set3List; break;
    }

    w->populateBox();
    w->setLastIndex();
}

void MainWindow::loadCurrentSet()
{
    QSettings settings("Maemo", "qradio");
    currentSet = settings.value("currentSet", 1).toInt();
    w->currentSet = currentSet;

    switch (currentSet)
    {
        case (1) : set1Action->setChecked(true); break;
        case (2) : set2Action->setChecked(true); break;
        case (3) : set3Action->setChecked(true); break;
    }
}

void MainWindow::saveCurrentSet()
{
    QSettings settings("Maemo", "qradio");
    settings.setValue("currentSet", currentSet);
}

void MainWindow::set1ActionTriggered()
{
    currentSet = 1;
    saveCurrentSet();
    w->currentSet = currentSet;
    w->populateBox();

}

void MainWindow::set2ActionTriggered()
{
     currentSet = 2;
     saveCurrentSet();
     w->currentSet = currentSet;
     w->populateBox();

}

void MainWindow::set3ActionTriggered()
{
     currentSet = 3;
     saveCurrentSet();
     w->currentSet = currentSet;
     w->populateBox();
}

void MainWindow::manualActionTriggered()
{
    int manualFreq = QInputDialog::getInt(this, tr("Manual Freq"), tr("Frequence"), 8750, 0, 13000, 10, 0, 0);
    w->setFreq(manualFreq*10000);
}

void MainWindow::renameSetsActionTriggered()
{
    set1Name = QInputDialog::getText(this, "Sets Rename", "Insert Set1 Name:", QLineEdit::Normal, set1Name, 0 , 0);
    set2Name = QInputDialog::getText(this, "Sets Rename", "Insert Set2 Name:", QLineEdit::Normal, set2Name, 0 , 0);
    set3Name = QInputDialog::getText(this, "Sets Rename", "Insert Set3 Name:", QLineEdit::Normal, set3Name, 0 , 0);
    saveSetsName();
    set1Action->setText(set1Name);
    set2Action->setText(set2Name);
    set3Action->setText(set3Name);
}

void MainWindow::deleteStationActionTriggered()
{
    int currentIndex = w->currentIndex;
    switch (currentSet)
    {
    case (1): w->set1List.removeAt(currentIndex); break;
    case (2): w->set2List.removeAt(currentIndex); break;
    case (3): w->set3List.removeAt(currentIndex); break;
    }
    w->populateBox();
}

void MainWindow::about()
{
    QMessageBox::about(this, tr("About QRadio"),
                tr("<h2>QRadio 0.0.3</h2>"
                   "<p>"
                   "<p>Written by Giovanni Grammatico (ggiovanni88@yahoo.it)"));

}

void MainWindow::aboutQt()
{
    QApplication::aboutQt();
}
