#ifndef CONTACTSMODEL_H
#define CONTACTSMODEL_H

#include <QObject>
#include <QStandardItemModel>
#include <QAction>
#include "contactdata.h"

class ContactsModel : public QObject
{
    Q_OBJECT
public:
    explicit ContactsModel(QObject *parent = 0);
    //ContactsModel();
    ~ContactsModel();
    QList<ContactData>* getUpdateableContacts();
    QList<QContactPhoneNumber> getCurrentNumbers(const QContact &contact);
    QList<QContactPhoneNumber> getUpdatedNumbers(const QList<QContactPhoneNumber> &currentNumbers);
    static QString getStringLabelFromSubTypes(const QStringList &subTypes);
    static bool updateContactNumbers(QContactManager *manager, QContactLocalId contactLocalId);
    void initAvailableManagers();

public:
    QList<ContactData>* iContacts;
    QMap<QString, QString>* iAvailableManagers;

private:
    QAction *aboutAction;

private:
    QString updateableNumber(const QString &number);

};

#endif // CONTACTSMODEL_H
