﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
from QonsoExtractor import QonsoExtractor
from PyQt4 import QtWebKit, QtCore
from PyQt4.QtNetwork import QNetworkRequest
from DebugLog import DebugLog

class QonsoExtractorUniversalMobile(QonsoExtractor):
   def __init__(self):
      DebugLog("QonsoExtractorUniversalMobile::init")
      
      QonsoExtractor.__init__(self)
      
      # URL présentant le formulaire pour la connection au compte
      self.urlbeforeAuth = "https://www.espaceclient.universalmobile.fr/ECU/login.jsf?urlNext=/monCompte.jsf"
      
      # URL où on envoie la requête POST pour l'authentification, en général, elle est dans le form 
      self.urlAuth = "https://www.espaceclient.universalmobile.fr/ECU/ECU/login.jsf"

      # URL de la page d'info conso
      self.urlconso = "http://www.espaceclient.universalmobile.fr/ECU/monCompte.jsf"
      
      self.hostname = "www.espaceclient.universalmobile.fr"
      
   def Authenticate(self):
      DebugLog("QonsoExtractorUniversalMobile::Authenticate")
      self.SetStatus('INFO', 'Authentification...')

      cookies = self.manager.cookieJar().cookiesForUrl(QtCore.QUrl("http://"+self.hostname))
      #request = self.PrepareRequest()
      # for cookie in cookies:
         # if cookie.name()=="JSESSIONID":
            # request.setRawHeader("Cookie", cookie.name()+"="+cookie.value()+"; cookieControle=controle; ")
      
      params = QtCore.QUrl()
      # Mettre ici les paramètres du formulaire (login, password, champs cachés)
      params.addQueryItem("iwebum_submitLogin_formulaireLogin:iwebum_submitLogin_login", self.login)
      params.addQueryItem("iwebum_submitLogin_formulaireLogin:iwebum_submitLogin_labelpassword", self.password)
      params.addQueryItem("iwebum_submitLogin_formulaireLogin:iwebum_submitLogin_commandbouton", "Valider")
      params.addQueryItem("javax.faces.ViewState", "j_id2")
      
      self.PostRequest(params)
      
   def DoReadResponse(self, reply):
      DebugLog("QonsoExtractorUniversalMobile::DoReadResponse")
      
      request = QNetworkRequest()
      page = QtWebKit.QWebPage()
      frame = page.currentFrame()

      # Phase d'initialisation, on va extraire 'idCorrelation', et on lance l'authentification avec
      DebugLog("authentication=="+self.authentication)
      
      if self.authentication=='Init':
         self.authentication = 'InProgress'
         self.Authenticate()
      
      # Authentification en cours, on récupère la page de redirection, et on fait une redirection
      elif self.authentication == 'InProgress':
         html = str( reply.readAll() )
         
         if not self.CheckForErrors(html):
            # pas d'erreur, c'est Lesieur, on peut charger la page des consommations
            request.setUrl( QtCore.QUrl(self.urlconso) ) 
            self.authentication = 'Done'
            self.manager.get(request)
      
   def CheckForErrors(self, html):
      r = re.compile('<p class="error">\s*<span>(.+?)<.*?</p>', re.DOTALL)
      res = r.search(html)
      
      if res:
         DebugLog("Erreur trouvée : "+str(res.groups()) )

         error = res.group(1).strip()
         if error:
            self.SetStatus('ERROR', error)
            return True
         else:
            DebugLog("Pas d'erreur en fait...")
            return False
      return False

   # Extraction des données, dépend de chaque opérateur
   def DoExtractDatas(self, html):
      DebugLog("QonsoExtractorUniversalMobile::DoExtractDatas")

      if self.CheckForErrors(html):
         return
      # Voix
      DebugLog("\n_____________________________________\nVoix\n")
      DebugLog("-------------------------------------\n")
      r = re.compile("<span.+?>Forfait\s+(.+?)\s*</span>.+?vous reste.+?(\d+,\d+).+?&euro;.+?au (\d{1,2}/\d{2}/\d{4}).+?(\d{2}):(\d{2}):\d{2}\s+sur votre compte", re.DOTALL)
      res = r.search(html)
      if res:
         DebugLog(res.groups())
         self.model.SetForfait( res.group(1) )
         self.model.SetConsoVoix( res.group(2).replace(",", "." ), euro=True )
         self.model.voix['str'] = 'Il vous reste '+res.group(2)+'&euro;'
         self.model.SetConsoVoixMax(None)
         self.model.SetConsoHorsForfait(None)
         self.model.SetDateProchaineFacture(None)
         DebugLog("forfait = "+res.group(1))
         DebugLog("voix = "+res.group(2))
            
      # Date de dernière communication
      DebugLog("\n_____________________________________\nDerniere communication\n")
      DebugLog("-------------------------------------\n")
      if res:
         date = res.group(3)
         time = "%sh%.2d" % ( res.group(4), int(res.group(5)) )
         self.model.lastTime = "Ma consommation au "+date + " &agrave; "+ time
         DebugLog("last="+self.model.lastTime)
