﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import os, re
from PyQt4 import QtCore, QtGui
from PyQt4.QtNetwork import QNetworkAccessManager, QNetworkRequest, QNetworkReply
from DebugLog import DebugLog, DebugFile

class QonsoExtractor:
   def __init__(self):
      self.urlconso = ""
      self.urlbeforeAuth = ""
      self.urlAuth = ""
      self.hostname = ""
      self.login = ""
      self.password = ""
      self.model = None
      self.view = None
      self.hmReS = ".*?((?:\s*\d{1,2}\s*[Hh])?\s*(?:\d{1,3}\s*(?:mi?n)?)).*?"
      self.hmRe = re.compile(self.hmReS)
      self.datasExtracted = False
      self.authentication = ''
      self.context = ''
      self.status = ''
      self.offline = True
      self.SetStatus('INFO', 'Connexion au site...')
      
   def SetView(self, view):
      self.view = view
      
   def SetLogin(self, login):
      self.login = login
   
   def SetPassword(self, password):
      self.password = password
      
   def SetOffline(self, offline):
      self.offline = offline

   def SetStatus(self, status, context):
      DebugLog(status+" : "+context)
      self.context = context
      self.status = status
      if self.view:
         self.view.update()

   def GetStatus(self):
      return (self.status, self.context)
      
   def SetModel(self, model):
      self.model = model
      
   # L'authentification est en 2 passes :
   # 1. charger la page de connection pour récupérer un identifiant
   # 2. ouvrir une requête d'identification avec cet identifiant et le numéro de tél et le code
   def InitAuthenticate(self):
      DebugLog('Extractor::InitAuthenticate')
      if not self.login or not self.password:
         return
      self.authentication = 'Init'
      
      self.manager = QNetworkAccessManager()
      QtCore.QObject.connect(self.manager, QtCore.SIGNAL("finished(QNetworkReply *)"), self.readResponse )

      request = QNetworkRequest()
      request.setUrl( QtCore.QUrl(self.urlbeforeAuth ) ) 
      self.manager.get(request)

   def Authenticate(self, idCorrelation):
      pass
      
   def readResponse(self, reply):
      error = reply.error()
      
      DebugLog(self.authentication)
      # test d'erreur, en général, pas de connection internet
      if error != QNetworkReply.NoError:
         self.SetStatus('ERROR', "Erreur, v&eacute;rifiez votre connection Internet")
      
      # On est bon. On charge la page et on extrait les données
      elif self.authentication == 'Done':      
         self.ExtractDatas( reply.readAll() )

      else:
         self.DoReadResponse(reply)
         
   def DoReadResponse(self, reply):
      pass

   def DoExtractDatas(self, datas):
      pass

   def UpdateConso(self):
      DebugLog( "QonsoExtractor::UpdateConso -> set request="+self.urlconso)
      self.authentication = 'Done'
      request = QNetworkRequest()
      request.setUrl( QtCore.QUrl(self.urlconso) ) 
      self.SetStatus('INFO', 'R&eacute;cup&eacute;ration des donn&eacute;es...')
      self.manager.get(request)
      
   def PrepareRequest(self):
      DebugLog( "QonsoExtractor::PrepareRequest")
      request = QNetworkRequest()
      request.setUrl( QtCore.QUrl(self.urlAuth) ) 
      request.setHeader(QNetworkRequest.ContentTypeHeader, "application/x-www-form-urlencoded")
      request.setRawHeader("Connection", "keep-alive")
      request.setRawHeader("Keep-Alive", "115");
      request.setRawHeader("Referer", self.urlbeforeAuth)
      request.setRawHeader("Host", self.hostname)
      return request

   def PostRequest(self, params, request=None):
      DebugLog( "QonsoExtractor::PostRequest")
      postData = QtCore.QByteArray()
      postData.append(params.toString()[1:])

      if not request:
         request = self.PrepareRequest()

      request.setRawHeader("Content-Length", "%s" % postData.length() )
      self.manager.post(request, postData)

   def ExtractDatas(self, datas):
      DebugLog("QonsoExtractor::ExtractDatas")
      
      self.SetStatus('INFO', 'Extraction des donn&eacute;es...')
      DebugFile(datas)
      self.DoExtractDatas( str(datas) )
      self.datasExtracted = True
      
      DebugLog('----------------------------------------------\nQonsoExtractor::ExtractDatas done')
      
      if self.view:
         DebugLog("QonsoExtractor:: update view")
         self.view.update()

      if self.model.NotFilled() and self.status!='ERROR' and not self.offline:
         DebugLog("QonsoExtractor:: Model not filled! UpdateConso")
         self.UpdateConso()
