#!/usr/bin/python

import sys
from PyQt4 import QtGui, QtCore

class WProgress(QtGui.QLabel):
   def __init__(self, parent):
      QtGui.QLabel.__init__(self, parent)
      self.setMinimumSize(1, 10)
      self.parent = parent
      self.setRange(0, 100)
      self.value = 0

   def setRange(self, min, max):
      self.min = min
      self.max = max
      self.num = [min, (min+max)/2, max]
         
   def setValue(self, value):
      self.value = value
      if self.value<self.min:
         self.value = self.min
         
      if self.value>self.max:
         self.value = self.max
      
   def paintEvent(self, event):
      paint = QtGui.QPainter()
      paint.begin(self)

      font = QtGui.QFont('Serif', 7, QtGui.QFont.Light)
      paint.setFont(font)

      size = self.size()
      x0 = int(size.width()*0.15)
      w = size.width()-2*x0
      h = 20

      if self.max-self.min>0:
         pcVal = float(self.value-self.min)/float(self.max-self.min)
         pcPixWidth = int(w*pcVal)

         step = int(round(w / 2.0))

         # draw progess bar
         paint.setPen(QtGui.QColor(255, 192, 123))
         paint.setBrush(QtGui.QColor(255, 192, 123))
         paint.drawRect(x0, h, pcPixWidth, h/3)

         # draw contour
         pen = QtGui.QPen(QtGui.QColor(20, 20, 20), 1, QtCore.Qt.SolidLine)
         paint.setPen(pen)
         paint.setBrush(QtCore.Qt.NoBrush)
         paint.drawRect(x0, h, w, h/3)

         j = 0

         for i in range(0, 3*step, step):
            paint.drawLine(x0+i, h-5, x0+i, h)
            metrics = paint.fontMetrics()
            fw = metrics.width(str(self.num[j]))
            paint.drawText(x0+i-fw/2, h/2, str(self.num[j]))
            j = j + 1

      paint.end()
