﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys, os
import ConfigParser
from PyQt4 import QtGui, QtCore
from QonsoExtractorBouygues import QonsoExtractorBouygues
from QonsoExtractorSFR import QonsoExtractorSFR
from QonsoModel import QonsoModel
from DlgConfig import DlgConfig
from WProgress import WProgress

class QonsoView(QtGui.QMainWindow):
   def __init__(self, parent=None):
      QtGui.QMainWindow.__init__(self, parent)
      
      self.offline = os.environ.has_key('OFFLINE')
      self.setMaximumSize(QtCore.QSize(800, 480))
      self.setWindowTitle('Qonso')
      #self.setStyleSheet("background-color: #FFF;" )
      
      try:
         self.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)
      except AttributeError:
         # not on Maemo5
         pass

      self.labels = dict()
      self.config = DlgConfig()
      self.model = QonsoModel()
      
      if not self.config.GetLogin() or not self.config.GetPassword() or not self.config.GetOperator():
         self.config.AskForCredentials()

      self.CreateExtractor()
      
      self.credentialsOk = False
      self.layoutsOK = False
      self.centralWidget = QtGui.QWidget()

      self.vbox = QtGui.QVBoxLayout()
      self.centralWidget.setLayout(self.vbox)
      
      self.setCentralWidget( self.centralWidget )

      self.credentialsOk = True

      if not self.offline:
         self.extractor.InitAuthenticate()
      else:
         f = open(r"..\..\..\data\SFR.htm", "r")
         self.extractor.ExtractDatas( f.read() )
         f.close()

      
   def CreateExtractor(self):
      if self.config.GetOperator()=='SFR':
         self.extractor = QonsoExtractorSFR(self)
      elif self.config.GetOperator()=='Bouygues Telecom':
         self.extractor = QonsoExtractorBouygues(self)

      self.extractor.SetLogin(self.config.GetLogin())
      self.extractor.SetPassword(self.config.GetPassword())
      self.extractor.SetModel(self.model)

   def Settings(self):
      self.config.AskForCredentials()
      self.credentialsOk = True
      self.CreateExtractor()
      self.extractor.InitAuthenticate()
      return
      
   def CreateLayouts(self):
      self.layoutsOK = True
      
      exit = QtGui.QAction(QtGui.QIcon('icons/exit.png'), u'Paramètres', self)
      exit.setShortcut('Ctrl+O')
      exit.setStatusTip('Options')
      self.connect(exit, QtCore.SIGNAL('triggered()'),self.Settings)
      
      menubar = self.menuBar()
      file = menubar.addMenu('&Options')
      file.addAction(exit)
   
      compteBox = self.CreateLayout('lasttime', None)
      voixBox = self.CreateLayout('voix', '/opt/qonso/icons/voix.png', True)
      smsBox = self.CreateLayout('sms', '/opt/qonso/icons/sms.png')
      dataBox = self.CreateLayout('data', '/opt/qonso/icons/data.png', True)
      hforfaitBox = self.CreateLayout('hforfait', '/opt/qonso/icons/hforfait.png', False)
      factureBox = self.CreateLayout('facture', None)

      self.UpdateConsoText()
      
      self.vbox.setSpacing(0)
      self.vbox.setMargin(0)

      self.vbox.addLayout(compteBox)
      self.vbox.addLayout(voixBox)
      self.vbox.addLayout(smsBox)
      self.vbox.addLayout(dataBox)
      self.vbox.addLayout(hforfaitBox)
      self.vbox.addLayout(factureBox)

   def CreateLayout(self, name, icon, progress=False):
      box = QtGui.QHBoxLayout()
      box.setSpacing(0)
      if icon:
         pixicon = QtGui.QPixmap(icon).scaled(64,64)
         label = QtGui.QLabel()
         label.setMinimumSize(QtCore.QSize(74, 74))
         label.setMaximumSize(QtCore.QSize(96, 134))
         label.setStyleSheet("background: #fff; margin: 0; padding: 5px; border-bottom: 1px solid #269CCA;")
         label.setPixmap(pixicon)
         box.addWidget(label)

      data = QtGui.QLabel()

      sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Preferred)
      sizePolicy.setHorizontalStretch(1)
      sizePolicy.setHeightForWidth(data.sizePolicy().hasHeightForWidth())
      data.setSizePolicy(sizePolicy)
      data.setMaximumSize(QtCore.QSize(800, 134))
      data.setStyleSheet("background: #fff;")
      data.setAlignment(QtCore.Qt.AlignCenter)
      
      vbox = QtGui.QVBoxLayout()
      vbox.addWidget(data)
      wid = None
      
      if progress:
         wid = WProgress(self)
         wid.setStyleSheet("background: #fff; margin: 0; padding: 5px; border-bottom: 1px solid #269CCA")
         vbox.addWidget(wid)
         wid.setMaximumSize(QtCore.QSize(800, 70))
      else:
         data.setStyleSheet("background: #fff; margin: 0; padding: 5px; border-bottom: 1px solid #269CCA")
         data.setMaximumSize(QtCore.QSize(800, 134))

      box.addLayout(vbox)
         
      self.labels[name] = data, wid
      self.layoutsOK = True
      return box

   def UpdateConsoText(self):
      status, context = self.extractor.GetStatus()
      if status=='ERROR':
         self.SetText(self.labels['lasttime'][0], "#FF0000", 10, context)
      else:
         if not self.model.GetLastTime():
            self.SetText(self.labels['lasttime'][0], "#269CCA", 16, context)
         else:
            self.SetText(self.labels['lasttime'][0], "#269CCA", 16, self.model.GetLastTime()+
                         "<br/>"+self.model.GetReport('str'))
         
      self.SetText(self.labels['voix'][0], "#EB5F18", 22, self.model.GetConsoVoix('str')+" / "+self.model.GetConsoVoixMax('str') )
      self.labels['voix'][1].setRange(0, self.model.GetConsoVoixMax('int'))
      self.labels['voix'][1].setValue( self.model.GetConsoVoix('int') )

      self.SetText(self.labels['sms'][0], "#EB5F18", 22, self.model.GetConsoSMS())

      dataMax = self.model.GetConsoDataMax()
      data = self.model.GetConsoData()
      self.SetText(self.labels['data'][0], "#EB5F18", 22, str(data)+" / "+str(dataMax)+"Mo")
      self.labels['data'][1].setRange(0, dataMax)
      self.labels['data'][1].setValue( data )
      
      self.SetText(self.labels['hforfait'][0], "#EB5F18", 22, self.model.GetConsoHorsForfait() )
      self.SetText(self.labels['facture'][0], "#269CCA", 16, self.model.GetDateProchaineFacture())

   def SetText(self, label, color, size, text):
      label.setText('<span style="color: %s; font-weight: bold; font-size: %dpt">%s</span>' % (color, size, text))
   
   def paintEvent(self, event):
      if self.credentialsOk and not self.layoutsOK:
         if not self.offline:
            self.extractor.InitAuthenticate()
         self.CreateLayouts()
      elif self.layoutsOK:
         self.UpdateConsoText()
      
   def closeEvent(self, event):
      self.config.WriteConfig()
      event.accept()
