﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import time, re, os
from PyQt4 import QtWebKit, QtCore, QtGui
from PyQt4.QtNetwork import QNetworkAccessManager, QNetworkRequest, QNetworkReply, QNetworkProxy, QNetworkCookieJar

class QonsoExtractor:
   def __init__(self, view):
      self.debug = os.environ.has_key('DEBUG')
      self.view = view
      self.SetStatus('INFO', "Initialisation...")
      self.page = QtWebKit.QWebPage()
      self.frame = self.page.currentFrame()
      self.urlconso = ""
      self.urlbeforeAuth = ""
      self.urlAuth = ""
      self.hostname = ""
      self.login = ""
      self.password = ""
      
   def SetLogin(self, login):
      self.login = login
   
   def SetPassword(self, password):
      self.password = password

   def Debug(self, msg):
      if self.debug:
         print msg
      # f = open('/home/user/debug.txt', 'a')
      # f.write(msg+"\n")
      # f.close()
      
   def SetStatus(self, status, context):
      self.context = context
      self.status = status
      self.view.update()

   def GetStatus(self):
      return (self.status, self.context)
      
   def SetModel(self, model):
      self.model = model
      
   # L'authentification est en 2 passes :
   # 1. charger la page de connection pour récupérer un identifiant
   # 2. ouvrir une requête d'identification avec cet identifiant et le numéro de tél et le code
   def InitAuthenticate(self):
      if not self.login or not self.password:
         return

      self.Debug(self.login)
      self.Debug(self.password)
      
      self.manager = QNetworkAccessManager()

      self.SetStatus('INFO', 'Connection au site...')

      request = QNetworkRequest()
      request.setUrl( QtCore.QUrl(self.urlbeforeAuth ) ) 
      self.manager.get(request)
      
      self.authentication = 'Init'
      
      QtCore.QObject.connect(self.manager, QtCore.SIGNAL("finished(QNetworkReply *)"), self.readResponse )

   def Authenticate(self, idCorrelation):
      pass
      
   def readResponse(self, reply):
      error = reply.error()
      
      self.Debug(self.authentication)
      # test d'erreur, en général, pas de connection internet
      if error != QNetworkReply.NoError:
         self.SetStatus('ERROR', "Erreur, v&eacute;rifiez votre connection Internet")
      
      # On est bon. On charge la page et on extrait les données
      elif self.authentication == 'Done':      
         self.ExtractDatas( reply.readAll() )

      else:
         self.DoReadResponse(reply)
         
   def DoReadResponse(self, reply):
      pass

   def ExtractDatas(self, datas):
      pass

